/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.tracing;

import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamIncomingMessage;
import java.util.List;
import java.util.Map;

public class JetStreamTrace {
    private final String stream;
    private final String subject;
    private final String messageId;
    private final Map<String, List<String>> headers;
    private final String payload;

    public JetStreamTrace(String stream, String subject, String messageId, Map<String, List<String>> headers, String payload) {
        this.stream = stream;
        this.subject = subject;
        this.messageId = messageId;
        this.headers = headers;
        this.payload = payload;
    }

    public String stream() {
        return this.stream;
    }

    public String subject() {
        return this.subject;
    }

    public String messageId() {
        return this.messageId;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public String payload() {
        return this.payload;
    }

    public static JetStreamTrace trace(JetStreamIncomingMessage<?> message) {
        return new JetStreamTrace(message.getStream(), message.getSubject(), message.getMessageId(), message.getHeaders(), new String(message.getData()));
    }
}

