/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.tracing;

import io.opentelemetry.context.propagation.TextMapGetter;
import io.quarkiverse.reactive.messaging.nats.jetstream.tracing.JetStreamTrace;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public enum JetStreamTraceTextMapGetter implements TextMapGetter<JetStreamTrace>
{
    INSTANCE;


    public Iterable<String> keys(JetStreamTrace carrier) {
        Map<String, List<String>> headers = carrier.headers();
        if (headers != null) {
            return headers.keySet();
        }
        return Collections.emptyList();
    }

    public String get(@Nullable JetStreamTrace carrier, String key) {
        List<String> value;
        Map<String, List<String>> headers;
        if (carrier != null && (headers = carrier.headers()) != null && (value = headers.get(key)) != null) {
            return String.join((CharSequence)",", value);
        }
        return null;
    }
}

