|Attribute (_alias_) | Description | Type   | Mandatory | Default |
| :---               | :----       | :----: | :----:    | :---    |
| *ack-timeout* | The duration to wait for an ack confirmation | String | false | `PT2S` |
| *ack-wait* | The duration that the server will wait for an ack for any individual message once it has been delivered to a consumer. If an ack is not received in time, the message will be redelivered. | String | false |  |
| *back-off* | The timing of re-deliveries as a comma-separated list of durations | String | false |  |
| *deliver-policy* | The point in the stream to receive messages from, either DeliverAll, DeliverLast, DeliverNew, DeliverByStartSequence, DeliverByStartTime, or DeliverLastPerSubject. | String | false |  |
| *description* | A description of the consumer. | String | false |  |
| *durable* | Sets the durable name for the consumer | String | false |  |
| *exponential-backoff* | Calculation a exponential backoff using deliveredCount metadata (NB back-off must undefined to work properly) | Boolean | false | `false` |
| *exponential-backoff-max-duration* | The maximum duration of exponential backoff | String | false | `PT2M` |
| *filter-subjects* | A comma separated list of subjects that overlap with the subjects bound to the stream to filter delivery to subscribers | String | false |  |
| *inactive-threshold* | Duration that instructs the server to cleanup consumers that are inactive for that long. | String | false |  |
| *max-ack-pending* | Defines the maximum number of messages, without an acknowledgement, that can be outstanding. | Integer | false |  |
| *max-deliver* | The maximum number of times a specific message delivery will be attempted | Integer | false |  |
| *memory-storage* | If set, forces the consumer state to be kept in memory rather than inherit the storage type of the stream (file in this case). | Boolean | false |  |
| *name* | The name of the NATS consumer | String | false |  |
| *payload-type* | The payload type | String | false |  |
| *publisher-type* | The publisher type (Pull, Push) | String | false | `Pull` |
| *pull.batch-size* | The size of batch of messages to be pulled in pull mode | int | false | `100` |
| *pull.max-expires* | The maximum duration a single pull request will wait for messages to be available to pull. | String | false |  |
| *pull.max-waiting* | The maximum number of waiting pull requests. | Integer | false |  |
| *pull.repull-at* | The point in the current batch to tell the server to start the next batch | int | false | `50` |
| *push.deliver-group* | The optional deliver group to join | String | false |  |
| *push.flow-control* | Enables per-subscription flow control using a sliding-window protocol. This protocol relies on the server and client exchanging messages to regulate when and how many messages are pushed to the client. This one-to-one flow control mechanism works in tandem with the one-to-many flow control imposed by MaxAckPending across all subscriptions bound to a consumer. | String | false |  |
| *push.headers-only* | Delivers only the headers of messages in the stream and not the bodies. Additionally adds Nats-Msg-Size header to indicate the size of the removed payload. | Boolean | false |  |
| *push.idle-heart-beat* | If the idle heartbeat period is set, the server will regularly send a status message to the client (i.e. when the period has elapsed) while there are no new messages to send. This lets the client know that the JetStream service is still up and running, even when there is no activity on the stream. The message status header will have a code of 100. Unlike FlowControl, it will have no reply to address. It may have a description such "Idle Heartbeat". Note that this heartbeat mechanism is all handled transparently by supported clients and does not need to be handled by the application. | String | false |  |
| *push.ordered* | Flag indicating whether this subscription should be ordered | Boolean | false |  |
| *push.rate-limit* | Used to throttle the delivery of messages to the consumer, in bits per second. | Long | false |  |
| *replay-policy* | If the policy is ReplayOriginal, the messages in the stream will be pushed to the client at the same rate that they were originally received, simulating the original timing of messages. If the policy is ReplayInstant (the default), the messages will be pushed to the client as fast as possible while adhering to the Ack Policy, Max Ack Pending and the client's ability to consume those messages. | String | false |  |
| *replicas* | Sets the number of replicas for the consumer's state. By default, when the value is set to zero, consumers inherit the number of replicas from the stream. | Integer | false |  |
| *retry-backoff* | The retry backoff in milliseconds for retry publishing messages | Long | false | `10000` |
| *stream* | The stream to subscribe or publish messages to | String | false |  |
| *subject* | The subject to subscribe or publish messages to | String | false |  |
| *trace-enabled* | Enable traces for publisher or subscriber | Boolean | false | `true` |
