/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public record JetStreamOutgoingMessageMetadata(String messageId, Map<String, List<String>> headers, Optional<String> subtopic) {
    public static JetStreamOutgoingMessageMetadata of(String messageId, Map<String, List<String>> headers, String subtopic) {
        return JetStreamOutgoingMessageMetadata.builder().messageId(messageId).headers(headers != null ? headers : Collections.emptyMap()).subtopic(Optional.ofNullable(subtopic)).build();
    }

    public static JetStreamOutgoingMessageMetadata of(String messageId, Map<String, List<String>> headers) {
        return JetStreamOutgoingMessageMetadata.builder().messageId(messageId).headers(headers != null ? headers : Collections.emptyMap()).subtopic(Optional.empty()).build();
    }

    public static JetStreamOutgoingMessageMetadata of(String messageId) {
        return JetStreamOutgoingMessageMetadata.builder().messageId(messageId).headers(Collections.emptyMap()).subtopic(Optional.empty()).build();
    }

    @Generated
    public static JetStreamOutgoingMessageMetadataBuilder builder() {
        return new JetStreamOutgoingMessageMetadataBuilder();
    }

    @Generated
    public static class JetStreamOutgoingMessageMetadataBuilder {
        @Generated
        private String messageId;
        @Generated
        private Map<String, List<String>> headers;
        @Generated
        private Optional<String> subtopic;

        @Generated
        JetStreamOutgoingMessageMetadataBuilder() {
        }

        @Generated
        public JetStreamOutgoingMessageMetadataBuilder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        @Generated
        public JetStreamOutgoingMessageMetadataBuilder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public JetStreamOutgoingMessageMetadataBuilder subtopic(Optional<String> subtopic) {
            this.subtopic = subtopic;
            return this;
        }

        @Generated
        public JetStreamOutgoingMessageMetadata build() {
            return new JetStreamOutgoingMessageMetadata(this.messageId, this.headers, this.subtopic);
        }

        @Generated
        public String toString() {
            return "JetStreamOutgoingMessageMetadata.JetStreamOutgoingMessageMetadataBuilder(messageId=" + this.messageId + ", headers=" + this.headers + ", subtopic=" + this.subtopic + ")";
        }
    }
}

