/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client;

import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionEvent;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionListener;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.KeyValueStoreSetup;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.StreamSetup;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.Subscription;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.Consumer;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.PurgeResult;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.StreamState;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.FetchConsumerConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.PublishConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.PushConsumerConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.ReaderConsumerConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.StreamConfiguration;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import org.eclipse.microprofile.reactive.messaging.Message;

public interface Connection
extends StreamSetup,
KeyValueStoreSetup,
AutoCloseable {
    public boolean isConnected();

    public Uni<Void> flush(Duration var1);

    public List<ConnectionListener> listeners();

    public void addListener(ConnectionListener var1);

    public void removeListener(ConnectionListener var1);

    default public void fireEvent(ConnectionEvent event, String message) {
        this.listeners().forEach(listener -> listener.onEvent(event, message));
    }

    public Uni<Consumer> getConsumer(String var1, String var2);

    public Uni<List<String>> getStreams();

    public Uni<List<String>> getSubjects(String var1);

    public Uni<List<String>> getConsumerNames(String var1);

    public Uni<Void> deleteConsumer(String var1, String var2);

    public Uni<Void> pauseConsumer(String var1, String var2, ZonedDateTime var3);

    public Uni<Void> resumeConsumer(String var1, String var2);

    public Uni<PurgeResult> purgeStream(String var1);

    public Uni<Long> getFirstSequence(String var1);

    public Uni<Void> deleteMessage(String var1, long var2, boolean var4);

    public Uni<StreamState> getStreamState(String var1);

    public Uni<StreamConfiguration> getStreamConfiguration(String var1);

    public Uni<List<PurgeResult>> purgeAllStreams();

    public <T> Uni<Message<T>> publish(Message<T> var1, PublishConfiguration var2);

    public <T> Uni<Message<T>> publish(Message<T> var1, PublishConfiguration var2, FetchConsumerConfiguration<T> var3);

    public <T> Uni<Message<T>> nextMessage(FetchConsumerConfiguration<T> var1);

    public <T> Multi<Message<T>> nextMessages(FetchConsumerConfiguration<T> var1);

    public <T> Uni<T> getKeyValue(String var1, String var2, Class<T> var3);

    public <T> Uni<Void> putKeyValue(String var1, String var2, T var3);

    public Uni<Void> deleteKeyValue(String var1, String var2);

    public <T> Uni<Message<T>> resolve(String var1, long var2);

    public <T> Uni<Subscription<T>> subscribtion(PushConsumerConfiguration<T> var1);

    public <T> Uni<Subscription<T>> subscribtion(ReaderConsumerConfiguration<T> var1);

    public <T> void close(Subscription<T> var1);
}

