/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client;

import io.nats.client.Options;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.Connection;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionFactory;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionListener;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ContextException;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.DefaultConnection;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.ConnectionConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.ConsumerMapper;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.MessageMapper;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.PayloadMapper;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.StreamStateMapper;
import io.quarkiverse.reactive.messaging.nats.jetstream.tracing.JetStreamInstrument;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.unchecked.Unchecked;
import io.smallrye.reactive.messaging.providers.connectors.ExecutionHolder;
import io.vertx.mutiny.core.Context;
import io.vertx.mutiny.core.Vertx;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Optional;
import org.jboss.logging.Logger;

@ApplicationScoped
public class DefaultConnectionFactory
implements ConnectionFactory {
    private static final Logger logger = Logger.getLogger(DefaultConnectionFactory.class);
    private final ExecutionHolder executionHolder;
    private final MessageMapper messageMapper;
    private final JetStreamInstrument instrumenter;
    private final PayloadMapper payloadMapper;
    private final ConsumerMapper consumerMapper;
    private final StreamStateMapper streamStateMapper;

    @Inject
    public DefaultConnectionFactory(ExecutionHolder executionHolder, MessageMapper messageMapper, JetStreamInstrument instrumenter, PayloadMapper payloadMapper, ConsumerMapper consumerMapper, StreamStateMapper streamStateMapper) {
        this.executionHolder = executionHolder;
        this.messageMapper = messageMapper;
        this.instrumenter = instrumenter;
        this.payloadMapper = payloadMapper;
        this.consumerMapper = consumerMapper;
        this.streamStateMapper = streamStateMapper;
    }

    @Override
    public Uni<? extends Connection> create(ConnectionConfiguration connectionConfiguration, ConnectionListener connectionListener) {
        return this.getContext().onItem().transformToUni(context -> Uni.createFrom().item(Unchecked.supplier(() -> new DefaultConnection(connectionConfiguration, connectionListener, (Context)context, this.messageMapper, this.payloadMapper, this.consumerMapper, this.streamStateMapper, this.instrumenter)))).onFailure().invoke(failure -> logger.errorf(failure, "Failed connecting to NATS: %s", (Object)failure.getMessage())).onFailure().retry().withBackOff(connectionConfiguration.connectionBackoff().orElse(Options.DEFAULT_RECONNECT_WAIT)).atMost((long)connectionConfiguration.connectionAttempts().orElse(60).intValue());
    }

    private Optional<Vertx> getVertx() {
        return Optional.ofNullable(this.executionHolder.vertx());
    }

    private Uni<Context> getContext() {
        return Uni.createFrom().item(Unchecked.supplier(() -> this.getVertx().map(Vertx::getOrCreateContext).orElseThrow(() -> new ContextException("No Vertx available"))));
    }
}

