/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration;

import io.nats.client.ErrorListener;
import io.quarkiverse.reactive.messaging.nats.NatsConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.DefaultConnectionConfiguration;
import java.time.Duration;
import java.util.Optional;

public interface ConnectionConfiguration {
    public String servers();

    public Optional<String> password();

    public Optional<String> username();

    public Optional<String> token();

    public boolean sslEnabled();

    public Optional<Integer> bufferSize();

    public Optional<ErrorListener> errorListener();

    public Optional<Long> connectionTimeout();

    public Optional<String> credentialPath();

    public Optional<String> keystorePath();

    public Optional<String> keystorePassword();

    public Optional<String> truststorePath();

    public Optional<String> truststorePassword();

    public Optional<String> tlsAlgorithm();

    public Optional<Duration> connectionBackoff();

    public Optional<Integer> connectionAttempts();

    public static ConnectionConfiguration of(NatsConfiguration configuration) {
        return new DefaultConnectionConfiguration(configuration);
    }
}

