/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration;

import io.nats.client.ConnectionListener;
import io.nats.client.ErrorListener;
import io.nats.client.Options;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.ConnectionConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.DefaultErrorListener;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;

public class ConnectionOptionsFactory {
    public Options create(ConnectionConfiguration configuration, ConnectionListener connectionListener) throws NoSuchAlgorithmException {
        String[] servers = configuration.servers().split(",");
        Options.Builder optionsBuilder = new Options.Builder();
        optionsBuilder.servers(servers);
        optionsBuilder.maxReconnects(configuration.connectionAttempts().orElse(60).intValue());
        optionsBuilder.connectionTimeout(configuration.connectionBackoff().orElse(Options.DEFAULT_RECONNECT_WAIT));
        if (connectionListener != null) {
            optionsBuilder.connectionListener(connectionListener);
        }
        optionsBuilder.errorListener(this.getErrorListener(configuration));
        configuration.username().ifPresent(username -> optionsBuilder.userInfo(username, configuration.password().orElse("")));
        configuration.token().map(String::toCharArray).ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).token(arg_0));
        configuration.credentialPath().ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).credentialPath(arg_0));
        configuration.keystorePath().ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).keystorePath(arg_0));
        configuration.keystorePassword().map(String::toCharArray).ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).keystorePassword(arg_0));
        configuration.truststorePath().ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).truststorePath(arg_0));
        configuration.truststorePassword().map(String::toCharArray).ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).truststorePassword(arg_0));
        configuration.bufferSize().ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).bufferSize(arg_0));
        configuration.connectionTimeout().ifPresent(connectionTimeout -> optionsBuilder.connectionTimeout(Duration.ofMillis(connectionTimeout)));
        if (configuration.sslEnabled()) {
            optionsBuilder.opentls();
        }
        configuration.tlsAlgorithm().ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).tlsAlgorithm(arg_0));
        return optionsBuilder.build();
    }

    public Options create(ConnectionConfiguration configuration) throws NoSuchAlgorithmException {
        return this.create(configuration, null);
    }

    private ErrorListener getErrorListener(ConnectionConfiguration configuration) {
        return configuration.errorListener().orElseGet(DefaultErrorListener::new);
    }
}

