/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration;

import io.nats.client.api.CompressionOption;
import io.nats.client.api.DiscardPolicy;
import io.nats.client.api.RetentionPolicy;
import io.nats.client.api.StorageType;
import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamBuildConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.DefaultStreamConfiguration;
import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public interface StreamConfiguration {
    public String name();

    public Optional<String> description();

    public Set<String> subjects();

    public Integer replicas();

    public StorageType storageType();

    public RetentionPolicy retentionPolicy();

    public CompressionOption compressionOption();

    public Optional<Long> maximumConsumers();

    public Optional<Long> maximumMessages();

    public Optional<Long> maximumMessagesPerSubject();

    public Optional<Long> maximumBytes();

    public Optional<Duration> maximumAge();

    public Optional<Integer> maximumMessageSize();

    public Optional<String> templateOwner();

    public Optional<DiscardPolicy> discardPolicy();

    public Optional<Duration> duplicateWindow();

    public Optional<Boolean> allowRollup();

    public Optional<Boolean> allowDirect();

    public Optional<Boolean> mirrorDirect();

    public Optional<Boolean> denyDelete();

    public Optional<Boolean> denyPurge();

    public Optional<Boolean> discardNewPerSubject();

    public Optional<Long> firstSequence();

    public static StreamConfiguration of(JetStreamBuildConfiguration.Stream stream) {
        return DefaultStreamConfiguration.builder().name(stream.name()).description(stream.description().orElse(null)).subjects(stream.subjects()).replicas(stream.replicas()).storageType(stream.storageType()).retentionPolicy(stream.retentionPolicy()).compressionOption(stream.compressionOption()).maximumConsumers(stream.maximumConsumers().orElse(null)).maximumMessages(stream.maximumMessages().orElse(null)).maximumMessagesPerSubject(stream.maximumMessagesPerSubject().orElse(null)).maximumBytes(stream.maximumBytes().orElse(null)).maximumAge(stream.maximumAge().orElse(null)).maximumMessageSize(stream.maximumMessageSize().orElse(null)).templateOwner(stream.templateOwner().orElse(null)).discardPolicy(stream.discardPolicy().orElse(null)).duplicateWindow(stream.duplicateWindow().orElse(null)).allowRollup(stream.allowRollup().orElse(null)).allowDirect(stream.allowDirect().orElse(null)).mirrorDirect(stream.mirrorDirect().orElse(null)).denyDelete(stream.denyDelete().orElse(null)).denyPurge(stream.denyPurge().orElse(null)).discardNewPerSubject(stream.discardNewPerSubject().orElse(null)).firstSequence(stream.firstSequence().orElse(null)).build();
    }

    public static StreamConfiguration of(io.nats.client.api.StreamConfiguration configuration) {
        return DefaultStreamConfiguration.builder().name(configuration.getName()).description(configuration.getDescription()).subjects(new HashSet<String>(configuration.getSubjects())).replicas(configuration.getReplicas()).storageType(configuration.getStorageType()).retentionPolicy(configuration.getRetentionPolicy()).compressionOption(configuration.getCompressionOption()).maximumConsumers(configuration.getMaxConsumers()).maximumMessages(Long.valueOf(configuration.getMaximumMessageSize())).maximumMessagesPerSubject(configuration.getMaxMsgsPerSubject()).maximumBytes(configuration.getMaxBytes()).maximumAge(configuration.getMaxAge()).maximumMessageSize(configuration.getMaximumMessageSize()).templateOwner(configuration.getTemplateOwner()).discardPolicy(configuration.getDiscardPolicy()).duplicateWindow(configuration.getDuplicateWindow()).allowRollup(configuration.getAllowRollup()).allowDirect(configuration.getAllowDirect()).mirrorDirect(configuration.getMirrorDirect()).denyDelete(configuration.getDenyDelete()).denyPurge(configuration.getDenyPurge()).discardNewPerSubject(configuration.isDiscardNewPerSubject()).firstSequence(configuration.getFirstSequence()).build();
    }
}

