/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration;

import io.nats.client.api.CompressionOption;
import io.nats.client.api.DiscardPolicy;
import io.nats.client.api.RetentionPolicy;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.StreamConfiguration;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;

public class StreamConfigurationFactory {
    public io.nats.client.api.StreamConfiguration create(StreamConfiguration streamConfiguration) {
        StreamConfiguration.Builder builder = io.nats.client.api.StreamConfiguration.builder().name(streamConfiguration.name()).storageType(streamConfiguration.storageType()).retentionPolicy(streamConfiguration.retentionPolicy()).replicas(streamConfiguration.replicas().intValue()).subjects(streamConfiguration.subjects()).compressionOption(streamConfiguration.compressionOption());
        builder = streamConfiguration.description().map(arg_0 -> ((StreamConfiguration.Builder)builder).description(arg_0)).orElse(builder);
        builder = streamConfiguration.maximumConsumers().map(arg_0 -> ((StreamConfiguration.Builder)builder).maxConsumers(arg_0)).orElse(builder);
        builder = streamConfiguration.maximumMessages().map(arg_0 -> ((StreamConfiguration.Builder)builder).maxMessages(arg_0)).orElse(builder);
        builder = streamConfiguration.maximumMessagesPerSubject().map(arg_0 -> ((StreamConfiguration.Builder)builder).maxMessagesPerSubject(arg_0)).orElse(builder);
        builder = streamConfiguration.maximumBytes().map(arg_0 -> ((StreamConfiguration.Builder)builder).maxBytes(arg_0)).orElse(builder);
        builder = streamConfiguration.maximumAge().map(arg_0 -> ((StreamConfiguration.Builder)builder).maxAge(arg_0)).orElse(builder);
        builder = streamConfiguration.maximumMessageSize().map(arg_0 -> ((StreamConfiguration.Builder)builder).maximumMessageSize(arg_0)).orElse(builder);
        builder = streamConfiguration.templateOwner().map(arg_0 -> ((StreamConfiguration.Builder)builder).templateOwner(arg_0)).orElse(builder);
        builder = streamConfiguration.discardPolicy().map(arg_0 -> ((StreamConfiguration.Builder)builder).discardPolicy(arg_0)).orElse(builder);
        builder = streamConfiguration.duplicateWindow().map(arg_0 -> ((StreamConfiguration.Builder)builder).duplicateWindow(arg_0)).orElse(builder);
        builder = streamConfiguration.allowRollup().map(arg_0 -> ((StreamConfiguration.Builder)builder).allowRollup(arg_0)).orElse(builder);
        builder = streamConfiguration.allowDirect().map(arg_0 -> ((StreamConfiguration.Builder)builder).allowDirect(arg_0)).orElse(builder);
        builder = streamConfiguration.mirrorDirect().map(arg_0 -> ((StreamConfiguration.Builder)builder).mirrorDirect(arg_0)).orElse(builder);
        builder = streamConfiguration.denyDelete().map(arg_0 -> ((StreamConfiguration.Builder)builder).denyDelete(arg_0)).orElse(builder);
        builder = streamConfiguration.denyPurge().map(arg_0 -> ((StreamConfiguration.Builder)builder).denyPurge(arg_0)).orElse(builder);
        builder = streamConfiguration.discardNewPerSubject().map(arg_0 -> ((StreamConfiguration.Builder)builder).discardNewPerSubject(arg_0)).orElse(builder);
        builder = streamConfiguration.firstSequence().map(arg_0 -> ((StreamConfiguration.Builder)builder).firstSequence(arg_0)).orElse(builder);
        return builder.build();
    }

    public Optional<io.nats.client.api.StreamConfiguration> create(io.nats.client.api.StreamConfiguration current, StreamConfiguration streamConfiguration) {
        Optional<Long> firstSequence;
        Optional<Boolean> discardNewPerSubject;
        Optional<Boolean> denyPurge;
        Optional<Boolean> denyDelete;
        Optional<Boolean> mirrorDirect;
        Optional<Boolean> allowDirect;
        Optional<Boolean> allowRollup;
        Optional<Duration> duplicateWindow;
        Optional<DiscardPolicy> discardPolicy;
        Optional<String> templateOwner;
        Optional<Integer> maximumMessageSize;
        Optional<Duration> maximumAge;
        Optional<Long> maximumBytes;
        Optional<Long> maximumMessagesPerSubject;
        Optional<Long> maximumMessages;
        Optional<Long> maximumConsumers;
        Optional<CompressionOption> compressionOption;
        Optional<Collection<String>> subjects;
        Optional<Integer> replicas;
        Optional<RetentionPolicy> retentionPolicy;
        Optional<StorageType> storageType;
        boolean updated = false;
        StreamConfiguration.Builder builder = io.nats.client.api.StreamConfiguration.builder();
        builder.name(current.getName());
        Optional<String> description = this.compare(current.getDescription(), streamConfiguration.description().orElse(null));
        if (description.isPresent()) {
            builder = builder.description(description.get());
            updated = true;
        }
        if ((storageType = this.compare(current.getStorageType(), streamConfiguration.storageType())).isPresent()) {
            builder = builder.storageType(storageType.get());
            updated = true;
        }
        if ((retentionPolicy = this.compare(current.getRetentionPolicy(), streamConfiguration.retentionPolicy())).isPresent()) {
            builder = builder.retentionPolicy(retentionPolicy.get());
            updated = true;
        }
        if ((replicas = this.compare(current.getReplicas(), streamConfiguration.replicas())).isPresent()) {
            builder = builder.replicas(replicas.get().intValue());
            updated = true;
        }
        if ((subjects = this.compare(current.getSubjects(), (Collection)streamConfiguration.subjects())).isPresent()) {
            builder = builder.subjects(subjects.get());
            updated = true;
        }
        if ((compressionOption = this.compare(current.getCompressionOption(), streamConfiguration.compressionOption())).isPresent()) {
            builder = builder.compressionOption(compressionOption.get());
            updated = true;
        }
        if ((maximumConsumers = this.compare(current.getMaxConsumers(), streamConfiguration.maximumConsumers().orElse(null))).isPresent()) {
            builder = builder.maxConsumers(maximumConsumers.get().longValue());
            updated = true;
        }
        if ((maximumMessages = this.compare(current.getMaxMsgs(), streamConfiguration.maximumMessages().orElse(null))).isPresent()) {
            builder = builder.maxMessages(maximumMessages.get().longValue());
            updated = true;
        }
        if ((maximumMessagesPerSubject = this.compare(current.getMaxMsgsPerSubject(), streamConfiguration.maximumMessagesPerSubject().orElse(null))).isPresent()) {
            builder = builder.maxMessagesPerSubject(maximumMessagesPerSubject.get().longValue());
            updated = true;
        }
        if ((maximumBytes = this.compare(current.getMaxBytes(), streamConfiguration.maximumBytes().orElse(null))).isPresent()) {
            builder = builder.maxBytes(maximumBytes.get().longValue());
            updated = true;
        }
        if ((maximumAge = this.compare(current.getMaxAge(), streamConfiguration.maximumAge().orElse(null))).isPresent()) {
            builder = builder.maxAge(maximumAge.get());
            updated = true;
        }
        if ((maximumMessageSize = this.compare(current.getMaximumMessageSize(), streamConfiguration.maximumMessageSize().orElse(null))).isPresent()) {
            builder = builder.maximumMessageSize(maximumMessageSize.get().intValue());
            updated = true;
        }
        if ((templateOwner = this.compare(current.getTemplateOwner(), streamConfiguration.templateOwner().orElse(null))).isPresent()) {
            builder = builder.templateOwner(templateOwner.get());
            updated = true;
        }
        if ((discardPolicy = this.compare(current.getDiscardPolicy(), streamConfiguration.discardPolicy().orElse(null))).isPresent()) {
            builder = builder.discardPolicy(discardPolicy.get());
            updated = true;
        }
        if ((duplicateWindow = this.compare(current.getDuplicateWindow(), streamConfiguration.duplicateWindow().orElse(null))).isPresent()) {
            builder = builder.duplicateWindow(duplicateWindow.get());
            updated = true;
        }
        if ((allowRollup = this.compare(current.getAllowRollup(), streamConfiguration.allowRollup().orElse(null))).isPresent()) {
            builder = builder.allowRollup(allowRollup.get().booleanValue());
            updated = true;
        }
        if ((allowDirect = this.compare(current.getAllowDirect(), streamConfiguration.allowDirect().orElse(null))).isPresent()) {
            builder = builder.allowDirect(allowDirect.get().booleanValue());
            updated = true;
        }
        if ((mirrorDirect = this.compare(current.getMirrorDirect(), streamConfiguration.mirrorDirect().orElse(null))).isPresent()) {
            builder = builder.mirrorDirect(mirrorDirect.get().booleanValue());
            updated = true;
        }
        if ((denyDelete = this.compare(current.getDenyDelete(), streamConfiguration.denyDelete().orElse(null))).isPresent()) {
            builder = builder.denyDelete(denyDelete.get().booleanValue());
            updated = true;
        }
        if ((denyPurge = this.compare(current.getDenyPurge(), streamConfiguration.denyPurge().orElse(null))).isPresent()) {
            builder = builder.denyPurge(denyPurge.get().booleanValue());
            updated = true;
        }
        if ((discardNewPerSubject = this.compare(current.isDiscardNewPerSubject(), streamConfiguration.discardNewPerSubject().orElse(null))).isPresent()) {
            builder = builder.discardNewPerSubject(discardNewPerSubject.get().booleanValue());
            updated = true;
        }
        if ((firstSequence = this.compare(current.getFirstSequence(), streamConfiguration.firstSequence().orElse(null))).isPresent()) {
            builder = builder.firstSequence(firstSequence.get().longValue());
            updated = true;
        }
        if (updated) {
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }

    private <T> Optional<T> compare(T currentValue, T newValue) {
        if (currentValue != null && newValue != null && !currentValue.equals(newValue)) {
            return Optional.of(newValue);
        }
        if (currentValue == null && newValue != null) {
            return Optional.of(newValue);
        }
        return Optional.empty();
    }

    private <T> Optional<Collection<T>> compare(Collection<T> currentValue, Collection<T> newValue) {
        if (currentValue != null && newValue != null && !currentValue.containsAll(newValue)) {
            return Optional.of(newValue);
        }
        if (currentValue == null && newValue != null) {
            return Optional.of(newValue);
        }
        return Optional.empty();
    }
}

