/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.mapper;

import io.nats.client.Message;
import io.quarkiverse.reactive.messaging.nats.jetstream.ExponentialBackoff;
import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamIncomingMessage;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.MessageMapper;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.PayloadMapper;
import io.quarkiverse.reactive.messaging.nats.jetstream.tracing.JetStreamInstrument;
import io.quarkiverse.reactive.messaging.nats.jetstream.tracing.JetStreamTrace;
import io.quarkus.arc.DefaultBean;
import io.smallrye.reactive.messaging.tracing.TracingUtils;
import io.vertx.mutiny.core.Context;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Duration;

@ApplicationScoped
@DefaultBean
public class DefaultMessageMapper
implements MessageMapper {
    public static final String MESSAGE_TYPE_HEADER = "message.type";
    private final PayloadMapper payloadMapper;
    private final JetStreamInstrument instrumenter;

    @Inject
    public DefaultMessageMapper(PayloadMapper payloadMapper, JetStreamInstrument instrumenter) {
        this.payloadMapper = payloadMapper;
        this.instrumenter = instrumenter;
    }

    @Override
    public <T> org.eclipse.microprofile.reactive.messaging.Message<T> of(Message message, boolean tracingEnabled, Class<T> payloadType, Context context, ExponentialBackoff exponentialBackoff, Duration ackTimeout) {
        try {
            JetStreamIncomingMessage<T> incomingMessage;
            JetStreamIncomingMessage<Object> jetStreamIncomingMessage = incomingMessage = payloadType != null ? new JetStreamIncomingMessage<T>(message, this.payloadMapper.of(message, payloadType), context, exponentialBackoff, ackTimeout) : new JetStreamIncomingMessage<Object>(message, this.payloadMapper.of(message).orElseGet(() -> message.getData()), context, exponentialBackoff, ackTimeout);
            if (tracingEnabled) {
                return TracingUtils.traceIncoming(this.instrumenter.receiver(), incomingMessage, (Object)JetStreamTrace.trace(incomingMessage));
            }
            return incomingMessage;
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
    }
}

