/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.mapper;

import io.nats.client.api.LostStreamData;
import io.nats.client.api.StreamState;
import io.nats.client.api.Subject;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.LostStreamDataState;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.StreamState;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.SubjectState;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.StreamStateMapper;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@ApplicationScoped
public class StreamStateMapperImpl
implements StreamStateMapper {
    @Override
    public io.quarkiverse.reactive.messaging.nats.jetstream.client.api.StreamState of(StreamState state) {
        List list1;
        if (state == null) {
            return null;
        }
        StreamState.StreamStateBuilder streamState = io.quarkiverse.reactive.messaging.nats.jetstream.client.api.StreamState.builder();
        streamState.messages(state.getMsgCount());
        streamState.bytes(state.getByteCount());
        streamState.consumers(state.getConsumerCount());
        streamState.subjects(state.getSubjectCount());
        streamState.deleted(state.getDeletedCount());
        streamState.subjectStates(this.subjectListToSubjectStateList(state.getSubjects()));
        Map map = state.getSubjectMap();
        if (map != null) {
            streamState.subjectMessages(new LinkedHashMap<String, Long>(map));
        }
        if ((list1 = state.getDeleted()) != null) {
            streamState.deletedStreamSequences(new ArrayList<Long>(list1));
        }
        streamState.firstSequence(state.getFirstSequence());
        streamState.lastSequence(state.getLastSequence());
        streamState.firstTime(state.getFirstTime());
        streamState.lastTime(state.getLastTime());
        streamState.lostStreamData(this.lostStreamDataToLostStreamDataState(state.getLostStreamData()));
        return streamState.build();
    }

    protected SubjectState subjectToSubjectState(Subject subject) {
        if (subject == null) {
            return null;
        }
        SubjectState.SubjectStateBuilder subjectState = SubjectState.builder();
        subjectState.name(subject.getName());
        subjectState.count(subject.getCount());
        return subjectState.build();
    }

    protected List<SubjectState> subjectListToSubjectStateList(List<Subject> list) {
        if (list == null) {
            return null;
        }
        ArrayList<SubjectState> list1 = new ArrayList<SubjectState>(list.size());
        for (Subject subject : list) {
            list1.add(this.subjectToSubjectState(subject));
        }
        return list1;
    }

    protected LostStreamDataState lostStreamDataToLostStreamDataState(LostStreamData lostStreamData) {
        if (lostStreamData == null) {
            return null;
        }
        LostStreamDataState.LostStreamDataStateBuilder lostStreamDataState = LostStreamDataState.builder();
        List list = lostStreamData.getMessages();
        if (list != null) {
            lostStreamDataState.messages(new ArrayList<Long>(list));
        }
        lostStreamDataState.bytes(lostStreamData.getBytes());
        return lostStreamDataState.build();
    }
}

