/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.processors.publisher;

import io.nats.client.api.AckPolicy;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.ReplayPolicy;
import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamConnectorIncomingConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.ConsumerConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.DefaultPayloadMapper;
import io.quarkiverse.reactive.messaging.nats.jetstream.processors.publisher.MessagePullPublisherConfiguration;
import io.quarkus.runtime.configuration.DurationConverter;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DefaultMessagePullPublisherConfiguration<T>
implements MessagePullPublisherConfiguration<T> {
    private final JetStreamConnectorIncomingConfiguration configuration;

    public DefaultMessagePullPublisherConfiguration(JetStreamConnectorIncomingConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public String channel() {
        return this.configuration.getChannel();
    }

    @Override
    public Duration retryBackoff() {
        return Duration.ofMillis(this.configuration.getRetryBackoff());
    }

    @Override
    public Optional<Integer> maxWaiting() {
        return this.configuration.getPullMaxWaiting();
    }

    @Override
    public Optional<Duration> maxRequestExpires() {
        return this.configuration.getPullMaxExpires().map(Duration::parse);
    }

    @Override
    public Integer maxRequestBatch() {
        return this.configuration.getPullBatchSize();
    }

    @Override
    public Integer rePullAt() {
        return this.configuration.getPullRepullAt();
    }

    @Override
    public String subject() {
        return this.configuration.getSubject().orElseThrow(() -> new IllegalStateException("No subject configured"));
    }

    @Override
    public ConsumerConfiguration<T> consumerConfiguration() {
        return new ConsumerConfiguration<T>(){

            @Override
            public String name() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getName().orElseGet(() -> this.durable().orElseGet(() -> String.format("%s-consumer", DefaultMessagePullPublisherConfiguration.this.subject()).replace("*", "").replace(".", "").replace(">", "").replace("\\", "").replace("/", "")));
            }

            @Override
            public String stream() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getStream().orElseThrow(() -> new IllegalStateException("No stream configured"));
            }

            @Override
            public Optional<String> durable() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getDurable();
            }

            @Override
            public List<String> filterSubjects() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getFilterSubjects().map(filterSubjects -> List.of(filterSubjects.split(","))).orElseGet(List::of);
            }

            @Override
            public Optional<Duration> ackWait() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getAckWait().map(Duration::parse);
            }

            @Override
            public Optional<DeliverPolicy> deliverPolicy() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getDeliverPolicy().map(DeliverPolicy::valueOf);
            }

            @Override
            public Optional<ZonedDateTime> startTime() {
                return Optional.empty();
            }

            @Override
            public Optional<String> description() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getDescription();
            }

            @Override
            public Optional<Duration> inactiveThreshold() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getInactiveThreshold().map(Duration::parse);
            }

            @Override
            public Optional<Long> maxAckPending() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getMaxAckPending();
            }

            @Override
            public Optional<Long> maxDeliver() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getMaxDeliver();
            }

            @Override
            public Optional<ReplayPolicy> replayPolicy() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getReplayPolicy().map(ReplayPolicy::valueOf);
            }

            @Override
            public Optional<Integer> replicas() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getReplicas();
            }

            @Override
            public Optional<Boolean> memoryStorage() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getMemoryStorage();
            }

            @Override
            public Optional<String> sampleFrequency() {
                return Optional.empty();
            }

            @Override
            public Map<String, String> metadata() {
                return Map.of();
            }

            @Override
            public List<Duration> backoff() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getBackOff().map(backoff -> backoff.split(",")).map(List::of).map(this::of).orElseGet(List::of);
            }

            @Override
            public Optional<Long> startSequence() {
                return Optional.empty();
            }

            @Override
            public Optional<AckPolicy> ackPolicy() {
                return Optional.empty();
            }

            @Override
            public Optional<ZonedDateTime> pauseUntil() {
                return Optional.empty();
            }

            @Override
            public Optional<Class<T>> payloadType() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getPayloadType().map(DefaultPayloadMapper::loadClass);
            }

            @Override
            public boolean exponentialBackoff() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getExponentialBackoff() != null ? DefaultMessagePullPublisherConfiguration.this.configuration.getExponentialBackoff() : false;
            }

            @Override
            public Duration exponentialBackoffMaxDuration() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getExponentialBackoffMaxDuration() != null ? Duration.parse(DefaultMessagePullPublisherConfiguration.this.configuration.getExponentialBackoffMaxDuration()) : null;
            }

            @Override
            public boolean traceEnabled() {
                return DefaultMessagePullPublisherConfiguration.this.configuration.getTraceEnabled();
            }

            @Override
            public Duration ackTimeout() {
                return Duration.parse(DefaultMessagePullPublisherConfiguration.this.configuration.getAckTimeout());
            }

            private List<Duration> of(List<String> values) {
                DurationConverter converter = new DurationConverter();
                if (values == null || values.isEmpty()) {
                    return List.of();
                }
                return values.stream().map(arg_0 -> ((DurationConverter)converter).convert(arg_0)).toList();
            }
        };
    }
}

