/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.tracing;

import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamIncomingMessage;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public record JetStreamTrace(String stream, String subject, String messageId, Map<String, List<String>> headers, String payload) {
    public static JetStreamTrace trace(JetStreamIncomingMessage<?> message) {
        return JetStreamTrace.builder().stream(message.getStream()).subject(message.getSubject()).messageId(message.getMessageId()).headers(message.getHeaders()).payload(new String(message.getData())).build();
    }

    @Generated
    public static JetStreamTraceBuilder builder() {
        return new JetStreamTraceBuilder();
    }

    @Generated
    public static class JetStreamTraceBuilder {
        @Generated
        private String stream;
        @Generated
        private String subject;
        @Generated
        private String messageId;
        @Generated
        private Map<String, List<String>> headers;
        @Generated
        private String payload;

        @Generated
        JetStreamTraceBuilder() {
        }

        @Generated
        public JetStreamTraceBuilder stream(String stream) {
            this.stream = stream;
            return this;
        }

        @Generated
        public JetStreamTraceBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        @Generated
        public JetStreamTraceBuilder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        @Generated
        public JetStreamTraceBuilder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public JetStreamTraceBuilder payload(String payload) {
            this.payload = payload;
            return this;
        }

        @Generated
        public JetStreamTrace build() {
            return new JetStreamTrace(this.stream, this.subject, this.messageId, this.headers, this.payload);
        }

        @Generated
        public String toString() {
            return "JetStreamTrace.JetStreamTraceBuilder(stream=" + this.stream + ", subject=" + this.subject + ", messageId=" + this.messageId + ", headers=" + this.headers + ", payload=" + this.payload + ")";
        }
    }
}

