/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream;

import io.quarkiverse.reactive.messaging.nats.NatsConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.Connection;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionFactory;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.DefaultConnectionListener;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.SetupException;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.StreamSetupConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.ConnectionConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.KeyValueSetupConfiguration;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;

@Recorder
public class JetStreamRecorder {
    private final RuntimeValue<NatsConfiguration> natsConfiguration;
    private final RuntimeValue<JetStreamConfiguration> jetStreamConfiguration;

    public JetStreamRecorder(RuntimeValue<NatsConfiguration> natsConfiguration, RuntimeValue<JetStreamConfiguration> jetStreamConfiguration) {
        this.natsConfiguration = natsConfiguration;
        this.jetStreamConfiguration = jetStreamConfiguration;
    }

    public void setup() {
        if (((JetStreamConfiguration)this.jetStreamConfiguration.getValue()).autoConfigure().booleanValue()) {
            ConnectionConfiguration connectionConfiguration = ConnectionConfiguration.of((NatsConfiguration)this.natsConfiguration.getValue());
            ConnectionFactory connectionFactory = (ConnectionFactory)CDI.current().select(ConnectionFactory.class, new Annotation[0]).get();
            try (Connection connection = (Connection)connectionFactory.create(connectionConfiguration, new DefaultConnectionListener()).await().indefinitely();){
                connection.streamManagement().onItem().transformToUni(streamManagement -> streamManagement.addStreams(StreamSetupConfiguration.of((JetStreamConfiguration)this.jetStreamConfiguration.getValue()))).await().indefinitely();
                connection.keyValueStoreManagement().onItem().transformToUni(keyValueStoreManagement -> keyValueStoreManagement.addKeyValueStores(KeyValueSetupConfiguration.of((JetStreamConfiguration)this.jetStreamConfiguration.getValue()))).await().indefinitely();
            }
            catch (Exception failure) {
                throw new SetupException(String.format("Unable to configure streams and key value stores: %s", failure.getMessage()), failure);
            }
        }
    }
}

