/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client;

import io.quarkiverse.reactive.messaging.nats.jetstream.client.Connection;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionFactory;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionListener;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ContextException;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.DefaultConnection;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.ConnectionConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.TracerFactory;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.ConsumerMapper;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.MessageMapper;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.PayloadMapper;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.StreamStateMapper;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.unchecked.Unchecked;
import io.smallrye.reactive.messaging.providers.connectors.ExecutionHolder;
import io.vertx.mutiny.core.Context;
import io.vertx.mutiny.core.Vertx;
import jakarta.enterprise.context.ApplicationScoped;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@ApplicationScoped
public class DefaultConnectionFactory
implements ConnectionFactory {
    private static final Duration DEFAULT_BACKOFF = Duration.ofSeconds(1L);
    private final ExecutionHolder executionHolder;
    private final MessageMapper messageMapper;
    private final PayloadMapper payloadMapper;
    private final ConsumerMapper consumerMapper;
    private final StreamStateMapper streamStateMapper;
    private final TracerFactory tracerFactory;

    @Override
    public <T> Uni<Connection<T>> create(ConnectionConfiguration connectionConfiguration) {
        return this.create(connectionConfiguration, List.of());
    }

    @Override
    public <T> Uni<Connection<T>> create(ConnectionConfiguration connectionConfiguration, ConnectionListener connectionListener) {
        return this.create(connectionConfiguration, List.of(connectionListener));
    }

    @Override
    public <T> Uni<Connection<T>> create(ConnectionConfiguration connectionConfiguration, List<ConnectionListener> connectionListeners) {
        Vertx vertx = this.getVertx();
        Context context = vertx.getOrCreateContext();
        if (connectionConfiguration.connectionAttempts().isEmpty()) {
            return context.executeBlocking(this.connect(connectionConfiguration, connectionListeners, vertx)).onFailure().retry().withBackOff(connectionConfiguration.connectionBackoff().orElse(DEFAULT_BACKOFF)).indefinitely();
        }
        return context.executeBlocking(this.connect(connectionConfiguration, connectionListeners, vertx)).onFailure().retry().withBackOff(connectionConfiguration.connectionBackoff().orElse(DEFAULT_BACKOFF)).atMost((long)connectionConfiguration.connectionAttempts().get().intValue());
    }

    private <T> Uni<Connection<T>> connect(ConnectionConfiguration connectionConfiguration, List<ConnectionListener> connectionListeners, Vertx vertx) {
        return Uni.createFrom().item(Unchecked.supplier(() -> new DefaultConnection(connectionConfiguration, connectionListeners, this.messageMapper, this.payloadMapper, this.consumerMapper, this.streamStateMapper, this.tracerFactory, vertx)));
    }

    private Vertx getVertx() {
        return Optional.ofNullable(this.executionHolder.vertx()).orElseThrow(() -> new ContextException("No Vertx available"));
    }

    @Generated
    public DefaultConnectionFactory(ExecutionHolder executionHolder, MessageMapper messageMapper, PayloadMapper payloadMapper, ConsumerMapper consumerMapper, StreamStateMapper streamStateMapper, TracerFactory tracerFactory) {
        this.executionHolder = executionHolder;
        this.messageMapper = messageMapper;
        this.payloadMapper = payloadMapper;
        this.consumerMapper = consumerMapper;
        this.streamStateMapper = streamStateMapper;
        this.tracerFactory = tracerFactory;
    }
}

