/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client;

import io.nats.client.Connection;
import io.nats.client.KeyValue;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.KeyValueException;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.KeyValueNotFoundException;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.KeyValueStore;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.PayloadMapper;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.unchecked.Unchecked;
import io.vertx.mutiny.core.Context;
import io.vertx.mutiny.core.Vertx;
import java.io.IOException;
import lombok.Generated;

public class DefaultKeyValueStore<T>
implements KeyValueStore<T> {
    private final String bucketName;
    private final Connection connection;
    private final PayloadMapper payloadMapper;
    private final Vertx vertx;

    @Override
    public Uni<T> get(String key, Class<T> valueType) {
        return this.context().executeBlocking(Uni.createFrom().item(Unchecked.supplier(() -> {
            try {
                KeyValue keyValue = this.connection.keyValue(this.bucketName);
                return keyValue.get(key);
            }
            catch (IOException failure) {
                throw new KeyValueException(failure);
            }
        })).onItem().ifNull().failWith(() -> new KeyValueNotFoundException(this.bucketName, key)).onItem().ifNotNull().transform(keyValueEntry -> this.payloadMapper.of(keyValueEntry.getValue(), valueType)));
    }

    @Override
    public Uni<Void> put(String key, T value) {
        return this.context().executeBlocking(Uni.createFrom().item(Unchecked.supplier(() -> {
            try {
                KeyValue keyValue = this.connection.keyValue(this.bucketName);
                keyValue.put(key, this.payloadMapper.of(value));
                return null;
            }
            catch (Exception failure) {
                throw new KeyValueException(failure);
            }
        })));
    }

    @Override
    public Uni<Void> delete(String key) {
        return this.context().executeBlocking(Uni.createFrom().item(Unchecked.supplier(() -> {
            try {
                KeyValue keyValue = this.connection.keyValue(this.bucketName);
                keyValue.delete(key);
                return null;
            }
            catch (Exception failure) {
                throw new KeyValueException(failure);
            }
        })));
    }

    private Context context() {
        return this.vertx.getOrCreateContext();
    }

    @Generated
    public DefaultKeyValueStore(String bucketName, Connection connection, PayloadMapper payloadMapper, Vertx vertx) {
        this.bucketName = bucketName;
        this.connection = connection;
        this.payloadMapper = payloadMapper;
        this.vertx = vertx;
    }
}

