/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client;

import io.nats.client.Connection;
import io.nats.client.KeyValueManagement;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.KeyValueStoreManagement;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.SetupException;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.KeyValueConfigurationFactory;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.KeyValueSetupConfiguration;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.unchecked.Unchecked;
import io.vertx.mutiny.core.Context;
import io.vertx.mutiny.core.Vertx;
import java.util.List;
import lombok.Generated;

class DefaultKeyValueStoreManagement
implements KeyValueStoreManagement {
    private final Connection connection;
    private final Vertx vertx;

    @Override
    public Uni<Void> addKeyValueStores(List<KeyValueSetupConfiguration> keyValueConfigurations) {
        return this.context().executeBlocking(Multi.createFrom().items(keyValueConfigurations.stream()).onItem().transformToUniAndMerge(this::addOrUpdateKeyValueStore).collect().last());
    }

    private Uni<Void> addOrUpdateKeyValueStore(KeyValueSetupConfiguration keyValueSetupConfiguration) {
        return Uni.createFrom().item(Unchecked.supplier(() -> {
            try {
                KeyValueManagement kvm = this.connection.keyValueManagement();
                KeyValueConfigurationFactory factory = new KeyValueConfigurationFactory();
                if (kvm.getBucketNames().contains(keyValueSetupConfiguration.bucketName())) {
                    kvm.update(factory.create(keyValueSetupConfiguration));
                } else {
                    kvm.create(factory.create(keyValueSetupConfiguration));
                }
                return null;
            }
            catch (Exception failure) {
                throw new SetupException(String.format("Unable to manage Key Value Store: %s", failure.getMessage()), failure);
            }
        }));
    }

    private Context context() {
        return this.vertx.getOrCreateContext();
    }

    @Generated
    public DefaultKeyValueStoreManagement(Connection connection, Vertx vertx) {
        this.connection = connection;
        this.vertx = vertx;
    }
}

