/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client;

import io.nats.client.ConnectionListener;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.Connection;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionEvent;
import lombok.Generated;

class InternalConnectionListener<T>
implements ConnectionListener {
    private final Connection<T> connection;

    public void connectionEvent(io.nats.client.Connection connection, ConnectionListener.Events type) {
        if (connection != null) {
            switch (type) {
                case CONNECTED: {
                    this.fireEvent(ConnectionEvent.Connected, "Connection established");
                    break;
                }
                case RECONNECTED: 
                case RESUBSCRIBED: {
                    this.fireEvent(ConnectionEvent.Reconnected, "Connection reestablished to server");
                    break;
                }
                case CLOSED: {
                    this.fireEvent(ConnectionEvent.Closed, "Connection closed");
                    break;
                }
                case DISCONNECTED: {
                    this.fireEvent(ConnectionEvent.Disconnected, "Connection disconnected");
                    break;
                }
                case LAME_DUCK: {
                    this.fireEvent(ConnectionEvent.CommunicationFailed, "Lame duck mode");
                }
            }
        }
    }

    private void fireEvent(ConnectionEvent event, String message) {
        this.connection.listeners().forEach(listener -> listener.onEvent(event, message));
    }

    @Generated
    public InternalConnectionListener(Connection<T> connection) {
        this.connection = connection;
    }
}

