/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.api;

import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.PublishConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.eclipse.microprofile.reactive.messaging.Message;

public record PublishMessageMetadata(String stream, String subject, byte[] payload, Class<?> type, String messageId, Map<String, List<String>> headers) {
    public Optional<String> streamOptional() {
        return Optional.ofNullable(this.stream);
    }

    public Optional<String> subjectOptional() {
        return Optional.ofNullable(this.subject);
    }

    public Optional<String> messageIdOptional() {
        return Optional.ofNullable(this.messageId);
    }

    public Optional<Map<String, List<String>>> headersOptional() {
        return Optional.ofNullable(this.headers);
    }

    public Optional<byte[]> payloadOptional() {
        return Optional.ofNullable(this.payload);
    }

    public Optional<Class<?>> typeOptional() {
        return Optional.ofNullable(this.type);
    }

    public static PublishMessageMetadata of(String messageId, Map<String, List<String>> headers) {
        return PublishMessageMetadata.builder().messageId(messageId).headers(headers).build();
    }

    public static PublishMessageMetadata of(String messageId) {
        return PublishMessageMetadata.builder().messageId(messageId).build();
    }

    public static <P> PublishMessageMetadata of(Message<P> message, PublishConfiguration configuration, byte[] payload) {
        Optional<PublishMessageMetadata> metadata = PublishMessageMetadata.getMetadata(message);
        Class type = metadata.flatMap(PublishMessageMetadata::typeOptional).orElseGet(() -> PublishMessageMetadata.getType(message));
        HashMap headers = metadata.flatMap(PublishMessageMetadata::headersOptional).map(HashMap::new).orElseGet(HashMap::new);
        if (type != null) {
            headers.putIfAbsent("message.type", List.of(type.getTypeName()));
        }
        return PublishMessageMetadata.builder().stream(metadata.flatMap(PublishMessageMetadata::streamOptional).orElseGet(configuration::stream)).subject(metadata.flatMap(PublishMessageMetadata::subjectOptional).orElseGet(configuration::subject)).payload(metadata.flatMap(PublishMessageMetadata::payloadOptional).orElse(payload)).type(type).messageId(metadata.flatMap(PublishMessageMetadata::messageIdOptional).orElseGet(() -> UUID.randomUUID().toString())).headers(headers).build();
    }

    private static <P> Optional<PublishMessageMetadata> getMetadata(Message<P> message) {
        return message.getMetadata(PublishMessageMetadata.class);
    }

    private static <P> Class<P> getType(Message<P> message) {
        return message.getPayload() != null ? message.getPayload().getClass() : null;
    }

    @Generated
    public static PublishMessageMetadataBuilder builder() {
        return new PublishMessageMetadataBuilder();
    }

    @Generated
    public static class PublishMessageMetadataBuilder {
        @Generated
        private String stream;
        @Generated
        private String subject;
        @Generated
        private byte[] payload;
        @Generated
        private Class<?> type;
        @Generated
        private String messageId;
        @Generated
        private Map<String, List<String>> headers;

        @Generated
        PublishMessageMetadataBuilder() {
        }

        @Generated
        public PublishMessageMetadataBuilder stream(String stream) {
            this.stream = stream;
            return this;
        }

        @Generated
        public PublishMessageMetadataBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        @Generated
        public PublishMessageMetadataBuilder payload(byte[] payload) {
            this.payload = payload;
            return this;
        }

        @Generated
        public PublishMessageMetadataBuilder type(Class<?> type) {
            this.type = type;
            return this;
        }

        @Generated
        public PublishMessageMetadataBuilder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        @Generated
        public PublishMessageMetadataBuilder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public PublishMessageMetadata build() {
            return new PublishMessageMetadata(this.stream, this.subject, this.payload, this.type, this.messageId, this.headers);
        }

        @Generated
        public String toString() {
            return "PublishMessageMetadata.PublishMessageMetadataBuilder(stream=" + this.stream + ", subject=" + this.subject + ", payload=" + Arrays.toString(this.payload) + ", type=" + this.type + ", messageId=" + this.messageId + ", headers=" + this.headers + ")";
        }
    }
}

