/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.api;

import io.nats.client.Message;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.JetStreamMessage;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.SubscribeMessageMetadata;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.HeaderMapper;
import io.smallrye.reactive.messaging.providers.helpers.VertxContext;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import io.smallrye.reactive.messaging.providers.locals.LocalContextMetadata;
import io.vertx.core.Context;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class SubscribeMessage<T>
implements JetStreamMessage<T> {
    private final Message message;
    private Metadata metadata;
    private final SubscribeMessageMetadata subscribeMessageMetadata;
    private final T payload;
    private final io.vertx.mutiny.core.Context context;

    public SubscribeMessage(Message message, T payload, io.vertx.mutiny.core.Context context) {
        this.message = message;
        this.subscribeMessageMetadata = SubscribeMessageMetadata.of(message);
        this.metadata = ContextAwareMessage.captureContextMetadata((Object[])new Object[]{this.subscribeMessageMetadata});
        this.payload = payload;
        this.context = context;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String messageId() {
        return this.subscribeMessageMetadata.messageId();
    }

    public byte[] getData() {
        return this.message.getData();
    }

    public String getSubject() {
        return this.subscribeMessageMetadata.subject();
    }

    public String getStream() {
        return this.subscribeMessageMetadata.stream();
    }

    public Long getStreamSequence() {
        return this.subscribeMessageMetadata.streamSequence();
    }

    public Long getConsumerSequence() {
        return this.subscribeMessageMetadata.consumerSequence();
    }

    public String getConsumer() {
        return this.subscribeMessageMetadata.consumer();
    }

    public Long getDeliveredCount() {
        return this.subscribeMessageMetadata.deliveredCount();
    }

    @Override
    public Map<String, List<String>> headers() {
        return HeaderMapper.toMessageHeaders(this.message.getHeaders());
    }

    public T getPayload() {
        return this.payload;
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return this::ack;
    }

    public CompletionStage<Void> ack() {
        return VertxContext.runOnContext((Context)this.context.getDelegate(), f -> {
            try {
                this.message.ack();
                this.runOnMessageContext(() -> f.complete(null));
            }
            catch (Exception e) {
                this.runOnMessageContext(() -> f.completeExceptionally(e));
            }
        });
    }

    public CompletionStage<Void> nack(Throwable reason, Metadata metadata) {
        return VertxContext.runOnContext((Context)this.context.getDelegate(), f -> {
            try {
                this.message.nak();
                this.runOnMessageContext(() -> f.complete(null));
            }
            catch (Exception e) {
                this.runOnMessageContext(() -> f.completeExceptionally(e));
            }
        });
    }

    public Function<Throwable, CompletionStage<Void>> getNack() {
        return arg_0 -> ((SubscribeMessage)this).nack(arg_0);
    }

    public synchronized void injectMetadata(Object metadataObject) {
        this.metadata = this.metadata.with(metadataObject);
    }

    public Optional<LocalContextMetadata> getContextMetadata() {
        return this.metadata.get(LocalContextMetadata.class);
    }

    public org.eclipse.microprofile.reactive.messaging.Message<T> addMetadata(Object metadata) {
        this.metadata = this.metadata.with(metadata);
        return this;
    }

    public org.eclipse.microprofile.reactive.messaging.Message<T> withMetadata(Iterable<Object> metadata) {
        this.metadata = this.metadata.with(metadata);
        return this;
    }

    public org.eclipse.microprofile.reactive.messaging.Message<T> withMetadata(Metadata metadata) {
        this.metadata = this.metadata.with((Object)metadata);
        return this;
    }

    public String toString() {
        return "SubscribeMessage{metadata=" + this.subscribeMessageMetadata + ", payload=" + this.payload + "}";
    }
}

