/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration;

import io.nats.client.api.AckPolicy;
import io.nats.client.api.ConsumerConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.ConsumerConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.PullConsumerConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.PushConsumerConfiguration;
import java.time.Duration;
import java.util.List;

public class ConsumerConfigurationFactory {
    public <T> io.nats.client.api.ConsumerConfiguration create(ConsumerConfiguration<T> configuration) {
        return this.builder(configuration).build();
    }

    public <T> io.nats.client.api.ConsumerConfiguration create(PullConsumerConfiguration<T> configuration) {
        ConsumerConfiguration.Builder builder = this.builder(configuration.consumerConfiguration());
        builder = configuration.maxWaiting().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).maxPullWaiting(arg_0)).orElse(builder);
        return builder.build();
    }

    public <T> io.nats.client.api.ConsumerConfiguration create(PushConsumerConfiguration<T> configuration) {
        ConsumerConfiguration.Builder builder = this.builder(configuration.consumerConfiguration());
        builder = configuration.flowControl().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).flowControl(arg_0)).orElse(builder);
        builder = configuration.idleHeartbeat().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).idleHeartbeat(arg_0)).orElse(builder);
        builder = configuration.rateLimit().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).rateLimit(arg_0)).orElse(builder);
        builder = configuration.headersOnly().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).headersOnly(arg_0)).orElse(builder);
        builder = configuration.deliverGroup().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).deliverGroup(arg_0)).orElse(builder);
        return builder.build();
    }

    private <T> ConsumerConfiguration.Builder builder(ConsumerConfiguration<T> configuration) {
        ConsumerConfiguration.Builder builder = io.nats.client.api.ConsumerConfiguration.builder();
        builder = configuration.durable().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).durable(arg_0)).orElse(builder);
        builder = builder.filterSubjects(List.of(configuration.subject()));
        builder = builder.name(configuration.name());
        builder = builder.ackPolicy(AckPolicy.Explicit);
        builder = configuration.ackWait().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).ackWait(arg_0)).orElse(builder);
        builder = configuration.deliverPolicy().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).deliverPolicy(arg_0)).orElse(builder);
        builder = configuration.startSequence().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).startSequence(arg_0)).orElse(builder);
        builder = configuration.startTime().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).startTime(arg_0)).orElse(builder);
        builder = configuration.description().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).description(arg_0)).orElse(builder);
        builder = configuration.inactiveThreshold().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).inactiveThreshold(arg_0)).orElse(builder);
        builder = configuration.maxAckPending().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).maxAckPending(arg_0)).orElse(builder);
        builder = configuration.maxDeliver().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).maxDeliver(arg_0)).orElse(builder);
        builder = configuration.replayPolicy().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).replayPolicy(arg_0)).orElse(builder);
        builder = configuration.replicas().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).numReplicas(arg_0)).orElse(builder);
        builder = configuration.memoryStorage().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).memStorage(arg_0)).orElse(builder);
        builder = configuration.sampleFrequency().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).sampleFrequency(arg_0)).orElse(builder);
        if (!configuration.metadata().isEmpty()) {
            builder = builder.metadata(configuration.metadata());
        }
        if (!configuration.backoff().isEmpty()) {
            builder = builder.backoff(configuration.backoff().toArray(new Duration[0]));
        }
        builder = configuration.ackPolicy().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).ackPolicy(arg_0)).orElse(builder);
        builder = configuration.pauseUntil().map(arg_0 -> ((ConsumerConfiguration.Builder)builder).pauseUntil(arg_0)).orElse(builder);
        return builder;
    }
}

