/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration;

import io.nats.client.ErrorListener;
import io.quarkiverse.reactive.messaging.nats.NatsConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.ConnectionConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.DefaultPayloadMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.Optional;

class DefaultConnectionConfiguration
implements ConnectionConfiguration {
    private final NatsConfiguration configuration;

    DefaultConnectionConfiguration(NatsConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public String servers() {
        return this.configuration.servers();
    }

    @Override
    public Optional<String> password() {
        return this.configuration.password();
    }

    @Override
    public Optional<String> username() {
        return this.configuration.username();
    }

    @Override
    public Optional<String> token() {
        return this.configuration.token();
    }

    @Override
    public Optional<String> credentialPath() {
        return this.configuration.credentialPath();
    }

    @Override
    public boolean sslEnabled() {
        return this.configuration.sslEnabled();
    }

    @Override
    public Optional<Integer> bufferSize() {
        return this.configuration.bufferSize();
    }

    @Override
    public Optional<ErrorListener> errorListener() {
        return this.configuration.errorListener().map(this::getInstanceOfErrorListener);
    }

    @Override
    public Optional<Long> connectionTimeout() {
        return this.configuration.connectionTimeout();
    }

    @Override
    public Optional<String> keystorePath() {
        return this.configuration.keystorePath();
    }

    @Override
    public Optional<String> keystorePassword() {
        return this.configuration.keystorePassword();
    }

    @Override
    public Optional<String> truststorePath() {
        return this.configuration.truststorePath();
    }

    @Override
    public Optional<String> truststorePassword() {
        return this.configuration.truststorePassword();
    }

    @Override
    public Optional<String> tlsAlgorithm() {
        return this.configuration.tlsAlgorithm();
    }

    @Override
    public Optional<Duration> connectionBackoff() {
        return this.configuration.connectionBackoff();
    }

    @Override
    public Optional<Integer> connectionAttempts() {
        return this.configuration.connectionAttempts();
    }

    private ErrorListener getInstanceOfErrorListener(String className) {
        try {
            Class clazz = DefaultPayloadMapper.loadClass(className);
            Constructor constructor = clazz.getConstructor(new Class[0]);
            return (ErrorListener)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Not able to create instance of error listener", e);
        }
    }
}

