/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration;

import io.nats.client.api.StorageType;
import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.DefaultKeyValueSetupConfiguration;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public interface KeyValueSetupConfiguration {
    public String bucketName();

    public Optional<String> description();

    public StorageType storageType();

    public Optional<Long> maxBucketSize();

    public Optional<Integer> maxHistoryPerKey();

    public Optional<Integer> maxValueSize();

    public Optional<Duration> ttl();

    public Optional<Integer> replicas();

    public Boolean compressed();

    public static List<KeyValueSetupConfiguration> of(JetStreamConfiguration configuration) {
        return configuration.keyValueStores().stream().map(store -> DefaultKeyValueSetupConfiguration.builder().bucketName(store.bucketName()).description(store.description()).storageType(store.storageType()).maxBucketSize(store.maxBucketSize()).maxHistoryPerKey(store.maxHistoryPerKey()).maxValueSize(store.maxValueSize()).ttl(store.ttl().map(Duration::parse)).replicas(store.replicas()).compressed(store.compressed()).build()).toList();
    }
}

