/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing;

import io.opentelemetry.context.Context;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.TraceSupplier;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import io.smallrye.reactive.messaging.TracingMetadata;
import io.smallrye.reactive.messaging.providers.locals.LocalContextMetadata;
import org.eclipse.microprofile.reactive.messaging.Message;

public class AttachContextTraceSupplier<T>
implements TraceSupplier<T> {
    @Override
    public Message<T> get(Message<T> message) {
        io.vertx.core.Context messageContext = message.getMetadata(LocalContextMetadata.class).map(LocalContextMetadata::context).orElse(null);
        Context otelContext = TracingMetadata.fromMessage(message).map(TracingMetadata::getCurrentContext).orElse(Context.current());
        if (messageContext != null && otelContext != null) {
            QuarkusContextStorage.INSTANCE.attach(messageContext, otelContext);
        }
        return message;
    }
}

