/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing;

import io.opentelemetry.api.OpenTelemetry;
import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.PublishTracer;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.SubscribeTracer;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.Tracer;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.TracerFactory;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.TracerType;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import lombok.Generated;

@ApplicationScoped
public class DefaultTracerFactory
implements TracerFactory {
    private final JetStreamConfiguration configuration;
    private final Instance<OpenTelemetry> openTelemetryInstance;

    @Override
    public <T> Tracer<T> create(TracerType tracerType) {
        return switch (tracerType) {
            default -> throw new IncompatibleClassChangeError();
            case TracerType.Subscribe -> new SubscribeTracer(this.configuration, this.openTelemetryInstance);
            case TracerType.Publish -> new PublishTracer(this.configuration, this.openTelemetryInstance);
        };
    }

    @Generated
    public DefaultTracerFactory(JetStreamConfiguration configuration, Instance<OpenTelemetry> openTelemetryInstance) {
        this.configuration = configuration;
        this.openTelemetryInstance = openTelemetryInstance;
    }
}

