/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.PublishMessageMetadata;
import java.nio.charset.StandardCharsets;

public class PublishMessageAttributesExtractor
implements AttributesExtractor<PublishMessageMetadata, Void> {
    private static final String MESSAGE_PAYLOAD = "message.payload";
    private final MessagingAttributesGetter<PublishMessageMetadata, Void> attributesGetter = new PublishMessagingAttributesGetter();

    public void onStart(AttributesBuilder attributes, Context parentContext, PublishMessageMetadata message) {
        attributes.put(MESSAGE_PAYLOAD, new String(message.payload(), StandardCharsets.UTF_8));
    }

    public void onEnd(AttributesBuilder attributes, Context context, PublishMessageMetadata tSubscribeMessage, Void unused, Throwable error) {
    }

    public MessagingAttributesGetter<PublishMessageMetadata, Void> getMessagingAttributesGetter() {
        return this.attributesGetter;
    }

    private static final class PublishMessagingAttributesGetter
    implements MessagingAttributesGetter<PublishMessageMetadata, Void> {
        private PublishMessagingAttributesGetter() {
        }

        public String getSystem(PublishMessageMetadata metadata) {
            return "jetstream";
        }

        public String getDestination(PublishMessageMetadata metadata) {
            return String.format("%s.%s", metadata.stream(), metadata.subject());
        }

        public boolean isTemporaryDestination(PublishMessageMetadata metadata) {
            return false;
        }

        public String getConversationId(PublishMessageMetadata message) {
            return null;
        }

        public Long getMessagePayloadSize(PublishMessageMetadata message) {
            return message.payload().length;
        }

        public Long getMessagePayloadCompressedSize(PublishMessageMetadata message) {
            return null;
        }

        public String getMessageId(PublishMessageMetadata message, Void unused) {
            return message.messageId();
        }
    }
}

