/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingSpanNameExtractor;
import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.PublishMessageMetadata;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.PublishMessageAttributesExtractor;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.PublishMessageTextMapSetter;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.TraceSupplier;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.Tracer;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.unchecked.Unchecked;
import io.smallrye.reactive.messaging.TracingMetadata;
import io.smallrye.reactive.messaging.tracing.TracingUtils;
import jakarta.enterprise.inject.Instance;
import org.eclipse.microprofile.reactive.messaging.Message;

public class PublishTracer<T>
implements Tracer<T> {
    private final JetStreamConfiguration configuration;
    private final Instrumenter<PublishMessageMetadata, Void> instrumenter;

    public PublishTracer(JetStreamConfiguration configuration, Instance<OpenTelemetry> openTelemetryInstance) {
        this.configuration = configuration;
        this.instrumenter = this.instrumenter(openTelemetryInstance);
    }

    @Override
    public Uni<Message<T>> withTrace(Message<T> message, TraceSupplier<T> traceSupplier) {
        if (this.configuration.trace().booleanValue()) {
            return this.addTracingMetadata(message).onItem().transformToUni(msg -> Uni.createFrom().item(Unchecked.supplier(() -> {
                msg.getMetadata(PublishMessageMetadata.class).ifPresent(metadata -> TracingUtils.traceOutgoing(this.instrumenter, (Message)msg, (Object)metadata));
                return traceSupplier.get(message);
            })));
        }
        return Uni.createFrom().item(message);
    }

    private Uni<Message<T>> addTracingMetadata(Message<T> message) {
        return Uni.createFrom().item(Unchecked.supplier(() -> {
            if (message.getMetadata(TracingMetadata.class).isEmpty()) {
                Context otelContext = QuarkusContextStorage.INSTANCE.current();
                return message.addMetadata((Object)TracingMetadata.withCurrent((Context)otelContext));
            }
            return message;
        }));
    }

    public Instrumenter<PublishMessageMetadata, Void> instrumenter(Instance<OpenTelemetry> openTelemetryInstance) {
        PublishMessageAttributesExtractor attributesExtractor = new PublishMessageAttributesExtractor();
        MessagingAttributesGetter<PublishMessageMetadata, Void> messagingAttributesGetter = attributesExtractor.getMessagingAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)TracingUtils.getOpenTelemetry(openTelemetryInstance), (String)"io.smallrye.reactive.messaging.jetstream", (SpanNameExtractor)MessagingSpanNameExtractor.create(messagingAttributesGetter, (MessageOperation)MessageOperation.SEND));
        return builder.addAttributesExtractor(MessagingAttributesExtractor.create(messagingAttributesGetter, (MessageOperation)MessageOperation.SEND)).addAttributesExtractor((AttributesExtractor)attributesExtractor).buildProducerInstrumenter((TextMapSetter)new PublishMessageTextMapSetter());
    }
}

