/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.SubscribeMessageMetadata;
import java.nio.charset.StandardCharsets;

public class SubscribeMessageAttributesExtractor
implements AttributesExtractor<SubscribeMessageMetadata, Void> {
    private static final String MESSAGE_PAYLOAD = "message.payload";
    private static final String MESSAGE_STREAM_SEQUENCE = "message.stream_sequence";
    private static final String MESSAGE_CONSUMER_SEQUENCE = "message.consumer_sequence";
    private static final String MESSAGE_CONSUMER = "message.consumer";
    private static final String MESSAGE_DELIVERED_COUNT = "message.delivered_count";
    private final MessagingAttributesGetter<SubscribeMessageMetadata, Void> attributesGetter = new SubscribeMessagingAttributesGetter();

    public void onStart(AttributesBuilder attributesBuilder, Context context, SubscribeMessageMetadata metadata) {
        attributesBuilder.put(MESSAGE_PAYLOAD, new String(metadata.payload(), StandardCharsets.UTF_8));
        attributesBuilder.put(MESSAGE_STREAM_SEQUENCE, metadata.streamSequence().longValue());
        attributesBuilder.put(MESSAGE_CONSUMER_SEQUENCE, metadata.consumerSequence().longValue());
        attributesBuilder.put(MESSAGE_CONSUMER, metadata.consumer());
        attributesBuilder.put(MESSAGE_DELIVERED_COUNT, metadata.deliveredCount().longValue());
    }

    public void onEnd(AttributesBuilder attributes, Context context, SubscribeMessageMetadata metadata, Void unused, Throwable error) {
    }

    public MessagingAttributesGetter<SubscribeMessageMetadata, Void> getMessagingAttributesGetter() {
        return this.attributesGetter;
    }

    private static final class SubscribeMessagingAttributesGetter
    implements MessagingAttributesGetter<SubscribeMessageMetadata, Void> {
        private SubscribeMessagingAttributesGetter() {
        }

        public String getSystem(SubscribeMessageMetadata metadata) {
            return "jetstream";
        }

        public String getDestination(SubscribeMessageMetadata metadata) {
            return String.format("%s.%s", metadata.stream(), metadata.subject());
        }

        public boolean isTemporaryDestination(SubscribeMessageMetadata metadata) {
            return false;
        }

        public String getConversationId(SubscribeMessageMetadata message) {
            return null;
        }

        public Long getMessagePayloadSize(SubscribeMessageMetadata metadata) {
            return metadata.payload().length;
        }

        public Long getMessagePayloadCompressedSize(SubscribeMessageMetadata message) {
            return null;
        }

        public String getMessageId(SubscribeMessageMetadata message, Void unused) {
            return message.messageId();
        }
    }
}

