/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingSpanNameExtractor;
import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.SubscribeMessageMetadata;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.SubscribeMessageAttributesExtractor;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.SubscribeMessageTextMapGetter;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.TraceSupplier;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.Tracer;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.unchecked.Unchecked;
import io.smallrye.reactive.messaging.tracing.TracingUtils;
import jakarta.enterprise.inject.Instance;
import lombok.Generated;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.jboss.logging.Logger;

public class SubscribeTracer<T>
implements Tracer<T> {
    @Generated
    private static final Logger log = Logger.getLogger(SubscribeTracer.class);
    private final JetStreamConfiguration configuration;
    private final Instrumenter<SubscribeMessageMetadata, Void> instrumenter;

    public SubscribeTracer(JetStreamConfiguration configuration, Instance<OpenTelemetry> openTelemetryInstance) {
        this.configuration = configuration;
        this.instrumenter = this.instrumenter(openTelemetryInstance);
    }

    @Override
    public Uni<Message<T>> withTrace(Message<T> message, TraceSupplier<T> traceSupplier) {
        log.debugf("Adding trace on thread: %s", (Object)Thread.currentThread().getName());
        if (this.configuration.trace().booleanValue()) {
            return Uni.createFrom().item(Unchecked.supplier(() -> {
                message.getMetadata(SubscribeMessageMetadata.class).ifPresent(metadata -> TracingUtils.traceIncoming(this.instrumenter, (Message)message, (Object)metadata));
                return traceSupplier.get(message);
            }));
        }
        return Uni.createFrom().item(message);
    }

    private Instrumenter<SubscribeMessageMetadata, Void> instrumenter(Instance<OpenTelemetry> openTelemetryInstance) {
        SubscribeMessageAttributesExtractor attributesExtractor = new SubscribeMessageAttributesExtractor();
        MessagingAttributesGetter<SubscribeMessageMetadata, Void> messagingAttributesGetter = attributesExtractor.getMessagingAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)TracingUtils.getOpenTelemetry(openTelemetryInstance), (String)"io.smallrye.reactive.messaging.jetstream", (SpanNameExtractor)MessagingSpanNameExtractor.create(messagingAttributesGetter, (MessageOperation)MessageOperation.RECEIVE));
        return builder.addAttributesExtractor((AttributesExtractor)attributesExtractor).addAttributesExtractor(MessagingAttributesExtractor.create(messagingAttributesGetter, (MessageOperation)MessageOperation.RECEIVE)).buildConsumerInstrumenter((TextMapGetter)new SubscribeMessageTextMapGetter());
    }
}

