/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.mapper;

import io.nats.client.api.ClusterInfo;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.api.SequenceInfo;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.Cluster;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.Consumer;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.ConsumerConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.Replica;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.Sequence;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.ConsumerMapper;
import jakarta.enterprise.context.ApplicationScoped;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@ApplicationScoped
public class ConsumerMapperImpl
implements ConsumerMapper {
    @Override
    public Consumer of(ConsumerInfo consumerInfo) {
        if (consumerInfo == null) {
            return null;
        }
        Consumer.ConsumerBuilder consumer = Consumer.builder();
        consumer.pending(consumerInfo.getNumPending());
        consumer.waiting(consumerInfo.getNumWaiting());
        consumer.acknowledgePending(consumerInfo.getNumAckPending());
        consumer.cluster(this.clusterInfoToCluster(consumerInfo.getClusterInfo()));
        consumer.configuration(this.consumerConfigurationToConsumerConfiguration(consumerInfo.getConsumerConfiguration()));
        consumer.stream(consumerInfo.getStreamName());
        consumer.created(consumerInfo.getCreationTime());
        consumer.name(consumerInfo.getName());
        consumer.delivered(this.sequenceInfoToSequence(consumerInfo.getDelivered()));
        consumer.ackFloor(this.sequenceInfoToSequence(consumerInfo.getAckFloor()));
        consumer.redelivered(consumerInfo.getRedelivered());
        consumer.paused(consumerInfo.getPaused());
        consumer.pauseRemaining(consumerInfo.getPauseRemaining());
        consumer.pushBound(consumerInfo.isPushBound());
        consumer.timestamp(consumerInfo.getTimestamp());
        return consumer.build();
    }

    protected Replica replicaToReplica(io.nats.client.api.Replica replica) {
        if (replica == null) {
            return null;
        }
        Replica.ReplicaBuilder replica1 = Replica.builder();
        replica1.name(replica.getName());
        replica1.current(replica.isCurrent());
        replica1.offline(replica.isOffline());
        replica1.active(replica.getActive());
        replica1.lag(replica.getLag());
        return replica1.build();
    }

    protected List<Replica> replicaListToReplicaList(List<io.nats.client.api.Replica> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Replica> list1 = new ArrayList<Replica>(list.size());
        for (io.nats.client.api.Replica replica : list) {
            list1.add(this.replicaToReplica(replica));
        }
        return list1;
    }

    protected Cluster clusterInfoToCluster(ClusterInfo clusterInfo) {
        if (clusterInfo == null) {
            return null;
        }
        Cluster.ClusterBuilder cluster = Cluster.builder();
        cluster.name(clusterInfo.getName());
        cluster.leader(clusterInfo.getLeader());
        cluster.replicas(this.replicaListToReplicaList(clusterInfo.getReplicas()));
        return cluster.build();
    }

    protected ConsumerConfiguration consumerConfigurationToConsumerConfiguration(io.nats.client.api.ConsumerConfiguration consumerConfiguration) {
        List list1;
        Map map;
        if (consumerConfiguration == null) {
            return null;
        }
        ConsumerConfiguration.ConsumerConfigurationBuilder consumerConfiguration1 = ConsumerConfiguration.builder();
        consumerConfiguration1.deliverPolicy(consumerConfiguration.getDeliverPolicy());
        consumerConfiguration1.ackPolicy(consumerConfiguration.getAckPolicy());
        consumerConfiguration1.replayPolicy(consumerConfiguration.getReplayPolicy());
        consumerConfiguration1.description(consumerConfiguration.getDescription());
        consumerConfiguration1.durable(consumerConfiguration.getDurable());
        consumerConfiguration1.name(consumerConfiguration.getName());
        consumerConfiguration1.deliverSubject(consumerConfiguration.getDeliverSubject());
        consumerConfiguration1.deliverGroup(consumerConfiguration.getDeliverGroup());
        consumerConfiguration1.sampleFrequency(consumerConfiguration.getSampleFrequency());
        consumerConfiguration1.startTime(consumerConfiguration.getStartTime());
        consumerConfiguration1.ackWait(consumerConfiguration.getAckWait());
        consumerConfiguration1.idleHeartbeat(consumerConfiguration.getIdleHeartbeat());
        consumerConfiguration1.maxExpires(consumerConfiguration.getMaxExpires());
        consumerConfiguration1.inactiveThreshold(consumerConfiguration.getInactiveThreshold());
        consumerConfiguration1.startSequence(consumerConfiguration.getStartSequence());
        consumerConfiguration1.maxDeliver(consumerConfiguration.getMaxDeliver());
        consumerConfiguration1.rateLimit(consumerConfiguration.getRateLimit());
        consumerConfiguration1.maxAckPending((int)consumerConfiguration.getMaxAckPending());
        consumerConfiguration1.maxPullWaiting((int)consumerConfiguration.getMaxPullWaiting());
        consumerConfiguration1.maxBatch((int)consumerConfiguration.getMaxBatch());
        consumerConfiguration1.maxBytes((int)consumerConfiguration.getMaxBytes());
        consumerConfiguration1.numReplicas(consumerConfiguration.getNumReplicas());
        consumerConfiguration1.pauseUntil(consumerConfiguration.getPauseUntil());
        consumerConfiguration1.flowControl(consumerConfiguration.isFlowControl());
        consumerConfiguration1.headersOnly(consumerConfiguration.isHeadersOnly());
        consumerConfiguration1.memStorage(consumerConfiguration.isMemStorage());
        List list = consumerConfiguration.getBackoff();
        if (list != null) {
            consumerConfiguration1.backoff(new ArrayList<Duration>(list));
        }
        if ((map = consumerConfiguration.getMetadata()) != null) {
            consumerConfiguration1.metadata(new LinkedHashMap<String, String>(map));
        }
        if ((list1 = consumerConfiguration.getFilterSubjects()) != null) {
            consumerConfiguration1.filterSubjects(new ArrayList<String>(list1));
        }
        return consumerConfiguration1.build();
    }

    protected Sequence sequenceInfoToSequence(SequenceInfo sequenceInfo) {
        if (sequenceInfo == null) {
            return null;
        }
        Sequence.SequenceBuilder sequence = Sequence.builder();
        sequence.consumerSequence(sequenceInfo.getConsumerSequence());
        sequence.streamSequence(sequenceInfo.getStreamSequence());
        sequence.lastActive(sequenceInfo.getLastActive());
        return sequence.build();
    }
}

