/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.nats.client.Message;
import io.nats.client.api.MessageInfo;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.PayloadMapper;
import io.quarkus.arc.DefaultBean;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.IOException;
import java.util.Optional;

@ApplicationScoped
@DefaultBean
public class DefaultPayloadMapper
implements PayloadMapper {
    private final ObjectMapper objectMapper;

    public DefaultPayloadMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public byte[] of(Object payload) {
        try {
            if (payload == null) {
                return new byte[0];
            }
            if (payload instanceof byte[]) {
                return (byte[])payload;
            }
            return this.objectMapper.writeValueAsBytes(payload);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T of(byte[] data, Class<T> type) {
        try {
            return (T)this.objectMapper.readValue(data, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> Optional<T> of(Message message) {
        return Optional.ofNullable(message).flatMap(m -> Optional.ofNullable(m.getHeaders())).flatMap(headers -> Optional.ofNullable(headers.getFirst("message.type"))).map(DefaultPayloadMapper::loadClass).map(type -> this.of(message.getData(), (Class)type));
    }

    @Override
    public <T> Optional<T> of(MessageInfo message) {
        return Optional.ofNullable(message).flatMap(m -> Optional.ofNullable(m.getHeaders())).flatMap(headers -> Optional.ofNullable(headers.getFirst("message.type"))).map(DefaultPayloadMapper::loadClass).map(type -> this.of(message.getData(), (Class)type));
    }

    public static <T> Class<T> loadClass(String type) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader.loadClass(type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

