/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream;

import io.nats.client.api.CompressionOption;
import io.nats.client.api.DiscardPolicy;
import io.nats.client.api.RetentionPolicy;
import io.nats.client.api.StorageType;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@ConfigMapping(prefix="quarkus.messaging.nats.jet-stream")
@ConfigRoot(phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public interface JetStreamBuildConfiguration {
    @WithDefault(value="true")
    public Boolean autoConfigure();

    @WithDefault(value="true")
    public Boolean trace();

    public List<Stream> streams();

    public List<KeyValueStore> keyValueStores();

    public static interface Stream {
        @WithDefault(value="false")
        public Boolean overwrite();

        public String name();

        public Optional<String> description();

        public Set<String> subjects();

        @WithDefault(value="1")
        public Integer replicas();

        @WithDefault(value="File")
        public StorageType storageType();

        @WithDefault(value="Interest")
        public RetentionPolicy retentionPolicy();

        @WithDefault(value="none")
        public CompressionOption compressionOption();

        public Optional<Long> maximumConsumers();

        public Optional<Long> maximumMessages();

        public Optional<Long> maximumMessagesPerSubject();

        public Optional<Long> maximumBytes();

        public Optional<Duration> maximumAge();

        public Optional<Integer> maximumMessageSize();

        public Optional<String> templateOwner();

        public Optional<DiscardPolicy> discardPolicy();

        public Optional<Duration> duplicateWindow();

        public Optional<Boolean> allowRollup();

        public Optional<Boolean> allowDirect();

        public Optional<Boolean> mirrorDirect();

        public Optional<Boolean> denyDelete();

        public Optional<Boolean> denyPurge();

        public Optional<Boolean> discardNewPerSubject();

        public Optional<Long> firstSequence();
    }

    public static interface KeyValueStore {
        public String bucketName();

        public Optional<String> description();

        @WithDefault(value="File")
        public StorageType storageType();

        public Optional<Long> maxBucketSize();

        public Optional<Integer> maxHistoryPerKey();

        public Optional<Integer> maxValueSize();

        public Optional<String> ttl();

        public Optional<Integer> replicas();

        @WithDefault(value="true")
        public Boolean compressed();
    }
}

