/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream;

import io.quarkiverse.reactive.messaging.nats.NatsConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamBuildConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.Connection;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionFactory;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.DefaultConnectionListener;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.SetupException;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.StreamSetupConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.ConnectionConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.KeyValueSetupConfiguration;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.time.Duration;

@Recorder
public class JetStreamRecorder {
    private static final Duration WAIT = Duration.ofSeconds(10L);
    private final RuntimeValue<NatsConfiguration> natsConfiguration;
    private final RuntimeValue<JetStreamBuildConfiguration> jetStreamConfiguration;

    public JetStreamRecorder(RuntimeValue<NatsConfiguration> natsConfiguration, RuntimeValue<JetStreamBuildConfiguration> jetStreamConfiguration) {
        this.natsConfiguration = natsConfiguration;
        this.jetStreamConfiguration = jetStreamConfiguration;
    }

    public void setup() {
        if (((JetStreamBuildConfiguration)this.jetStreamConfiguration.getValue()).autoConfigure().booleanValue()) {
            ConnectionConfiguration connectionConfiguration = ConnectionConfiguration.of((NatsConfiguration)this.natsConfiguration.getValue());
            ConnectionFactory connectionFactory = (ConnectionFactory)CDI.current().select(ConnectionFactory.class, new Annotation[0]).get();
            try (Connection connection = (Connection)connectionFactory.create(connectionConfiguration, new DefaultConnectionListener()).await().atMost(WAIT);){
                connection.addStreams(StreamSetupConfiguration.of((JetStreamBuildConfiguration)this.jetStreamConfiguration.getValue())).await().atMost(WAIT);
                connection.addOrUpdateKeyValueStores(KeyValueSetupConfiguration.of((JetStreamBuildConfiguration)this.jetStreamConfiguration.getValue())).await().atMost(WAIT);
            }
            catch (Throwable failure) {
                throw new SetupException(String.format("Unable to configure streams and key value stores: %s", failure.getMessage()), failure);
            }
        }
    }
}

