/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client;

import io.quarkiverse.reactive.messaging.nats.jetstream.client.ContextException;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ContextSupplier;
import io.smallrye.reactive.messaging.providers.connectors.ExecutionHolder;
import io.vertx.mutiny.core.Vertx;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Optional;

@ApplicationScoped
public class Context {
    private final ExecutionHolder executionHolder;

    public Context(ExecutionHolder executionHolder) {
        this.executionHolder = executionHolder;
    }

    public <T> T withContext(ContextSupplier<T> supplier) {
        io.vertx.mutiny.core.Context context = this.getContext();
        return supplier.get(context);
    }

    private Optional<Vertx> getVertx() {
        return Optional.ofNullable(this.executionHolder.vertx());
    }

    private io.vertx.mutiny.core.Context getContext() {
        return this.getVertx().map(Vertx::getOrCreateContext).orElseThrow(() -> new ContextException("No Vertx available"));
    }
}

