/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client;

import io.nats.client.Options;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.Connection;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionFactory;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionListener;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.DefaultConnection;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.ConnectionConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.ConsumerMapper;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.MessageMapper;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.PayloadMapper;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.StreamStateMapper;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.unchecked.Unchecked;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.jboss.logging.Logger;

@ApplicationScoped
public class DefaultConnectionFactory
implements ConnectionFactory {
    private static final Logger logger = Logger.getLogger(DefaultConnectionFactory.class);
    private final MessageMapper messageMapper;
    private final PayloadMapper payloadMapper;
    private final ConsumerMapper consumerMapper;
    private final StreamStateMapper streamStateMapper;

    @Inject
    public DefaultConnectionFactory(MessageMapper messageMapper, PayloadMapper payloadMapper, ConsumerMapper consumerMapper, StreamStateMapper streamStateMapper) {
        this.messageMapper = messageMapper;
        this.payloadMapper = payloadMapper;
        this.consumerMapper = consumerMapper;
        this.streamStateMapper = streamStateMapper;
    }

    @Override
    public Uni<? extends Connection> create(ConnectionConfiguration connectionConfiguration, ConnectionListener connectionListener) {
        return Uni.createFrom().item(Unchecked.supplier(() -> new DefaultConnection(connectionConfiguration, connectionListener, this.messageMapper, this.payloadMapper, this.consumerMapper, this.streamStateMapper))).onFailure().invoke(failure -> logger.errorf(failure, "Failed connecting to NATS: %s", (Object)failure.getMessage())).onFailure().retry().withBackOff(connectionConfiguration.connectionBackoff().orElse(Options.DEFAULT_RECONNECT_WAIT)).atMost((long)connectionConfiguration.connectionAttempts().orElse(60).intValue());
    }
}

