/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client;

import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.PublishMessage;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.SubscribeMessageMetadata;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.PublishConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;

public record JetStreamMessage(String stream, String subject, String messageId, Map<String, List<String>> headers, byte[] payload, Long streamSequence, Long consumerSequence, String consumer, Long deliveredCount) {
    public static final String MESSAGE_TYPE_HEADER = "message.type";

    public static <T> JetStreamMessage of(PublishMessage<T> message) {
        return JetStreamMessage.builder().stream(message.getStream()).subject(message.getSubject()).messageId(message.messageId()).headers(message.headers()).payload(message.getData()).streamSequence(message.getStreamSequence()).consumerSequence(message.getConsumerSequence()).consumer(message.getConsumer()).deliveredCount(message.getDeliveredCount()).build();
    }

    public static <T> JetStreamMessage of(byte[] payload, Class<T> type, SubscribeMessageMetadata metadata, PublishConfiguration configuration) {
        String messageId = metadata != null && metadata.messageId() != null ? metadata.messageId() : UUID.randomUUID().toString();
        String subject = configuration.subject();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        if (type != null) {
            headers.putIfAbsent(MESSAGE_TYPE_HEADER, List.of(type.getTypeName()));
        }
        return JetStreamMessage.builder().stream(configuration.stream()).subject(subject).messageId(messageId).headers(headers).payload(payload).build();
    }

    @Generated
    public static JetStreamMessageBuilder builder() {
        return new JetStreamMessageBuilder();
    }

    @Generated
    public static class JetStreamMessageBuilder {
        @Generated
        private String stream;
        @Generated
        private String subject;
        @Generated
        private String messageId;
        @Generated
        private Map<String, List<String>> headers;
        @Generated
        private byte[] payload;
        @Generated
        private Long streamSequence;
        @Generated
        private Long consumerSequence;
        @Generated
        private String consumer;
        @Generated
        private Long deliveredCount;

        @Generated
        JetStreamMessageBuilder() {
        }

        @Generated
        public JetStreamMessageBuilder stream(String stream) {
            this.stream = stream;
            return this;
        }

        @Generated
        public JetStreamMessageBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        @Generated
        public JetStreamMessageBuilder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        @Generated
        public JetStreamMessageBuilder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public JetStreamMessageBuilder payload(byte[] payload) {
            this.payload = payload;
            return this;
        }

        @Generated
        public JetStreamMessageBuilder streamSequence(Long streamSequence) {
            this.streamSequence = streamSequence;
            return this;
        }

        @Generated
        public JetStreamMessageBuilder consumerSequence(Long consumerSequence) {
            this.consumerSequence = consumerSequence;
            return this;
        }

        @Generated
        public JetStreamMessageBuilder consumer(String consumer) {
            this.consumer = consumer;
            return this;
        }

        @Generated
        public JetStreamMessageBuilder deliveredCount(Long deliveredCount) {
            this.deliveredCount = deliveredCount;
            return this;
        }

        @Generated
        public JetStreamMessage build() {
            return new JetStreamMessage(this.stream, this.subject, this.messageId, this.headers, this.payload, this.streamSequence, this.consumerSequence, this.consumer, this.deliveredCount);
        }

        @Generated
        public String toString() {
            return "JetStreamMessage.JetStreamMessageBuilder(stream=" + this.stream + ", subject=" + this.subject + ", messageId=" + this.messageId + ", headers=" + this.headers + ", payload=" + Arrays.toString(this.payload) + ", streamSequence=" + this.streamSequence + ", consumerSequence=" + this.consumerSequence + ", consumer=" + this.consumer + ", deliveredCount=" + this.deliveredCount + ")";
        }
    }
}

