/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.api;

import io.nats.client.Message;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.ExponentialBackoff;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.JetStreamMessage;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.PublishMessageMetadata;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.HeaderMapper;
import io.smallrye.reactive.messaging.providers.helpers.VertxContext;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import io.vertx.core.Context;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class PublishMessage<T>
implements JetStreamMessage<T> {
    private final Message message;
    private Metadata metadata;
    private final PublishMessageMetadata incomingMetadata;
    private final T payload;
    private final io.vertx.mutiny.core.Context context;
    private final ExponentialBackoff exponentialBackoff;
    private final Duration ackTimeout;

    public PublishMessage(Message message, T payload, io.vertx.mutiny.core.Context context, ExponentialBackoff exponentialBackoff, Duration ackTimeout) {
        this.message = message;
        this.incomingMetadata = PublishMessageMetadata.of(message);
        this.exponentialBackoff = exponentialBackoff;
        this.metadata = ContextAwareMessage.captureContextMetadata((Object[])new Object[]{this.incomingMetadata});
        this.payload = payload;
        this.context = context;
        this.ackTimeout = ackTimeout;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String messageId() {
        return this.incomingMetadata.messageId();
    }

    public byte[] getData() {
        return this.message.getData();
    }

    public String getSubject() {
        return this.incomingMetadata.subject();
    }

    public String getStream() {
        return this.incomingMetadata.stream();
    }

    public Long getStreamSequence() {
        return this.incomingMetadata.streamSequence();
    }

    public Long getConsumerSequence() {
        return this.incomingMetadata.consumerSequence();
    }

    public String getConsumer() {
        return this.incomingMetadata.consumer();
    }

    public Long getDeliveredCount() {
        return this.incomingMetadata.deliveredCount();
    }

    @Override
    public Map<String, List<String>> headers() {
        return HeaderMapper.toMessageHeaders(this.message.getHeaders());
    }

    public T getPayload() {
        return this.payload;
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return this::ack;
    }

    public CompletionStage<Void> ack() {
        return VertxContext.runOnContext((Context)this.context.getDelegate(), f -> {
            try {
                this.message.ackSync(this.ackTimeout);
                this.runOnMessageContext(() -> f.complete(null));
            }
            catch (InterruptedException | TimeoutException e) {
                this.runOnMessageContext(() -> f.completeExceptionally(e));
            }
        });
    }

    public CompletionStage<Void> nack(Throwable reason, Metadata metadata) {
        return VertxContext.runOnContext((Context)this.context.getDelegate(), f -> {
            if (this.exponentialBackoff.enabled()) {
                metadata.get(PublishMessageMetadata.class).ifPresentOrElse(m -> this.message.nakWithDelay(this.exponentialBackoff.getDuration(m.deliveredCount())), () -> ((Message)this.message).nak());
            } else {
                this.message.nak();
            }
            this.runOnMessageContext(() -> f.complete(null));
        });
    }

    public Function<Throwable, CompletionStage<Void>> getNack() {
        return arg_0 -> ((PublishMessage)this).nack(arg_0);
    }

    public synchronized void injectMetadata(Object metadataObject) {
        this.metadata = this.metadata.with(metadataObject);
    }

    public String toString() {
        return "IncomingNatsMessage{metadata=" + this.incomingMetadata + ", payload=" + this.payload + "}";
    }
}

