/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.api;

import io.nats.client.Message;
import io.nats.client.api.MessageInfo;
import io.nats.client.impl.Headers;
import io.smallrye.common.constraint.NotNull;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public record PublishMessageMetadata(String stream, String subject, String messageId, Map<String, List<String>> headers, Long deliveredCount, String consumer, Long streamSequence, Long consumerSequence, ZonedDateTime timestamp) {
    public static PublishMessageMetadata of(@NotNull Message message) {
        Optional<Headers> headers = Optional.ofNullable(message.getHeaders());
        return PublishMessageMetadata.builder().stream(message.metaData().getStream()).subject(message.getSubject()).messageId(headers.map(h -> h.getFirst("Nats-Msg-Id")).orElse(null)).headers(headers.map(PublishMessageMetadata::headers).orElseGet(HashMap::new)).deliveredCount(message.metaData().deliveredCount()).consumer(message.metaData().getConsumer()).streamSequence(message.metaData().streamSequence()).consumerSequence(message.metaData().consumerSequence()).timestamp(message.metaData().timestamp()).build();
    }

    public static PublishMessageMetadata of(MessageInfo message) {
        Optional<Headers> headers = Optional.ofNullable(message.getHeaders());
        return PublishMessageMetadata.builder().stream(message.getStream()).subject(message.getSubject()).messageId(headers.map(h -> h.getFirst("Nats-Msg-Id")).orElse(null)).headers(headers.map(PublishMessageMetadata::headers).orElseGet(HashMap::new)).deliveredCount(null).consumer(null).streamSequence(message.getSeq()).consumerSequence(null).timestamp(message.getTime()).build();
    }

    public static Map<String, List<String>> headers(Headers messageHeaders) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        messageHeaders.entrySet().forEach(entry -> headers.put((String)entry.getKey(), (List)entry.getValue()));
        return headers;
    }

    @Override
    public String toString() {
        return "JetStreamIncomingMessageMetadata{stream='" + this.stream + "', subject='" + this.subject + "', messageId='" + this.messageId + "', headers=" + this.headers + ", deliveredCount=" + this.deliveredCount + "}";
    }

    @Generated
    public static PublishMessageMetadataBuilder builder() {
        return new PublishMessageMetadataBuilder();
    }

    @Generated
    public static class PublishMessageMetadataBuilder {
        @Generated
        private String stream;
        @Generated
        private String subject;
        @Generated
        private String messageId;
        @Generated
        private Map<String, List<String>> headers;
        @Generated
        private Long deliveredCount;
        @Generated
        private String consumer;
        @Generated
        private Long streamSequence;
        @Generated
        private Long consumerSequence;
        @Generated
        private ZonedDateTime timestamp;

        @Generated
        PublishMessageMetadataBuilder() {
        }

        @Generated
        public PublishMessageMetadataBuilder stream(String stream) {
            this.stream = stream;
            return this;
        }

        @Generated
        public PublishMessageMetadataBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        @Generated
        public PublishMessageMetadataBuilder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        @Generated
        public PublishMessageMetadataBuilder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public PublishMessageMetadataBuilder deliveredCount(Long deliveredCount) {
            this.deliveredCount = deliveredCount;
            return this;
        }

        @Generated
        public PublishMessageMetadataBuilder consumer(String consumer) {
            this.consumer = consumer;
            return this;
        }

        @Generated
        public PublishMessageMetadataBuilder streamSequence(Long streamSequence) {
            this.streamSequence = streamSequence;
            return this;
        }

        @Generated
        public PublishMessageMetadataBuilder consumerSequence(Long consumerSequence) {
            this.consumerSequence = consumerSequence;
            return this;
        }

        @Generated
        public PublishMessageMetadataBuilder timestamp(ZonedDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public PublishMessageMetadata build() {
            return new PublishMessageMetadata(this.stream, this.subject, this.messageId, this.headers, this.deliveredCount, this.consumer, this.streamSequence, this.consumerSequence, this.timestamp);
        }

        @Generated
        public String toString() {
            return "PublishMessageMetadata.PublishMessageMetadataBuilder(stream=" + this.stream + ", subject=" + this.subject + ", messageId=" + this.messageId + ", headers=" + this.headers + ", deliveredCount=" + this.deliveredCount + ", consumer=" + this.consumer + ", streamSequence=" + this.streamSequence + ", consumerSequence=" + this.consumerSequence + ", timestamp=" + this.timestamp + ")";
        }
    }
}

