/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.api;

import io.nats.client.api.MessageInfo;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.JetStreamMessage;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.PublishMessageMetadata;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.HeaderMapper;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;
import org.jboss.logging.Logger;

public class ResolvedMessage<T>
implements JetStreamMessage<T> {
    private static final Logger logger = Logger.getLogger(ResolvedMessage.class);
    private final MessageInfo message;
    private Metadata metadata;
    private final PublishMessageMetadata incomingMetadata;
    private final T payload;

    public ResolvedMessage(MessageInfo message, T payload) {
        this.message = message;
        this.incomingMetadata = PublishMessageMetadata.of(message);
        this.metadata = ContextAwareMessage.captureContextMetadata((Object[])new Object[]{this.incomingMetadata});
        this.payload = payload;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String messageId() {
        return this.incomingMetadata.messageId();
    }

    public byte[] getData() {
        return this.message.getData();
    }

    public String getSubject() {
        return this.incomingMetadata.subject();
    }

    public String getStream() {
        return this.incomingMetadata.stream();
    }

    public MessageInfo messageInfo() {
        return this.message;
    }

    @Override
    public Map<String, List<String>> headers() {
        return HeaderMapper.toMessageHeaders(this.message.getHeaders());
    }

    public T getPayload() {
        return this.payload;
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return this::ack;
    }

    public CompletionStage<Void> ack() {
        return CompletableFuture.supplyAsync(() -> {
            logger.debugf("Message with id = %s acknowledged", (Object)this.messageId());
            return null;
        });
    }

    public CompletionStage<Void> nack(Throwable reason, Metadata metadata) {
        return CompletableFuture.supplyAsync(() -> {
            logger.errorf(reason, "Message with id = %s not acknowledged", (Object)this.messageId());
            throw new RuntimeException(reason);
        });
    }

    public Function<Throwable, CompletionStage<Void>> getNack() {
        return arg_0 -> ((ResolvedMessage)this).nack(arg_0);
    }

    public synchronized void injectMetadata(Object metadataObject) {
        this.metadata = this.metadata.with(metadataObject);
    }

    public Message<T> addMetadata(Object metadata) {
        this.injectMetadata(metadata);
        return this;
    }

    public String toString() {
        return "JetStreamMessage{message=" + this.message + ", metadata=" + this.metadata + ", incomingMetadata=" + this.incomingMetadata + ", payload=" + this.payload + "}";
    }
}

