/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.api;

import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.JetStreamMessage;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.SubscribeMessageMetadata;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.PublishConfiguration;
import io.smallrye.reactive.messaging.providers.MetadataInjectableMessage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.eclipse.microprofile.reactive.messaging.Message;

public record SubscribeMessage<T>(String stream, String subject, byte[] payload, String type, String messageId, Map<String, List<String>> headers, Message<T> message) implements JetStreamMessage<T>
{
    public void injectMetadata(Object o) {
        Message<T> message = this.message;
        if (message instanceof MetadataInjectableMessage) {
            MetadataInjectableMessage metadataInjectableMessage = (MetadataInjectableMessage)message;
            metadataInjectableMessage.injectMetadata(o);
        }
    }

    public T getPayload() {
        return (T)this.message.getPayload();
    }

    public static <T> SubscribeMessage<T> of(Message<T> message, byte[] payload, PublishConfiguration configuration) {
        Optional metadata = message.getMetadata(SubscribeMessageMetadata.class);
        String stream = metadata.flatMap(SubscribeMessageMetadata::streamOptional).orElseGet(configuration::stream);
        String subject = metadata.flatMap(SubscribeMessageMetadata::subjectOptional).orElseGet(configuration::subject);
        String messageId = metadata.flatMap(SubscribeMessageMetadata::messageIdOptional).orElseGet(() -> UUID.randomUUID().toString());
        String type = message.getPayload() != null ? message.getPayload().getClass().getTypeName() : null;
        HashMap headers = metadata.flatMap(SubscribeMessageMetadata::headersOptional).map(HashMap::new).orElseGet(HashMap::new);
        if (type != null) {
            headers.putIfAbsent("message.type", List.of(type));
        }
        return SubscribeMessage.builder().stream(stream).subject(subject).payload(payload).message(message).type(type).messageId(messageId).headers(headers).build();
    }

    @Generated
    public static <T> SubscribeMessageBuilder<T> builder() {
        return new SubscribeMessageBuilder();
    }

    @Generated
    public static class SubscribeMessageBuilder<T> {
        @Generated
        private String stream;
        @Generated
        private String subject;
        @Generated
        private byte[] payload;
        @Generated
        private String type;
        @Generated
        private String messageId;
        @Generated
        private Map<String, List<String>> headers;
        @Generated
        private Message<T> message;

        @Generated
        SubscribeMessageBuilder() {
        }

        @Generated
        public SubscribeMessageBuilder<T> stream(String stream) {
            this.stream = stream;
            return this;
        }

        @Generated
        public SubscribeMessageBuilder<T> subject(String subject) {
            this.subject = subject;
            return this;
        }

        @Generated
        public SubscribeMessageBuilder<T> payload(byte[] payload) {
            this.payload = payload;
            return this;
        }

        @Generated
        public SubscribeMessageBuilder<T> type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public SubscribeMessageBuilder<T> messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        @Generated
        public SubscribeMessageBuilder<T> headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public SubscribeMessageBuilder<T> message(Message<T> message) {
            this.message = message;
            return this;
        }

        @Generated
        public SubscribeMessage<T> build() {
            return new SubscribeMessage<T>(this.stream, this.subject, this.payload, this.type, this.messageId, this.headers, this.message);
        }

        @Generated
        public String toString() {
            return "SubscribeMessage.SubscribeMessageBuilder(stream=" + this.stream + ", subject=" + this.subject + ", payload=" + Arrays.toString(this.payload) + ", type=" + this.type + ", messageId=" + this.messageId + ", headers=" + this.headers + ", message=" + this.message + ")";
        }
    }
}

