/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingSpanNameExtractor;
import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamBuildConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.PublishMessage;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.ResolvedMessage;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.SubscribeMessage;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.PublishConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.PublishMessageAttributesExtractor;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.PublishMessageTextMapGetter;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.ResolvedMessageAttributesExtractor;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.ResolvedMessageTextMapGetter;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.SubscribeMessageAttributesExtractor;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.SubscribeMessageTextMapSetter;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.Tracer;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.PayloadMapper;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.tuples.Tuple2;
import io.smallrye.mutiny.unchecked.Unchecked;
import io.smallrye.reactive.messaging.tracing.TracingUtils;
import jakarta.enterprise.inject.Instance;
import org.eclipse.microprofile.reactive.messaging.Message;

public class DefaultTracer<T>
implements Tracer<T> {
    private final JetStreamBuildConfiguration configuration;
    private final PayloadMapper payloadMapper;
    private final OpenTelemetry openTelemetry;
    private final Instrumenter<PublishMessage<T>, Void> publisher;
    private final Instrumenter<SubscribeMessage<T>, Void> subscriber;
    private final Instrumenter<ResolvedMessage<T>, Void> resolver;

    public DefaultTracer(Instance<OpenTelemetry> openTelemetryInstance, JetStreamBuildConfiguration configuration, PayloadMapper payloadMapper) {
        this.configuration = configuration;
        this.payloadMapper = payloadMapper;
        this.openTelemetry = TracingUtils.getOpenTelemetry(openTelemetryInstance);
        this.subscriber = this.subscriber(this.openTelemetry);
        this.publisher = this.publisher(this.openTelemetry);
        this.resolver = this.resolver(this.openTelemetry);
    }

    @Override
    public Uni<SubscribeMessage<T>> withTrace(Message<T> message, PublishConfiguration configuration) {
        return Uni.createFrom().item(Unchecked.supplier(() -> this.createSubscribeMessage(message, configuration))).onItem().transformToUni(this::traceOutgoing);
    }

    @Override
    public Uni<Message<T>> withTrace(PublishMessage<T> message) {
        if (this.configuration.trace().booleanValue()) {
            return Uni.createFrom().item(Unchecked.supplier(() -> {
                TracingUtils.traceIncoming(this.publisher, (Message)message, (Object)message);
                return message;
            }));
        }
        return Uni.createFrom().item(message);
    }

    @Override
    public Uni<Message<T>> withTrace(ResolvedMessage<T> message) {
        if (this.configuration.trace().booleanValue()) {
            return Uni.createFrom().item(Unchecked.supplier(() -> {
                TracingUtils.traceIncoming(this.resolver, (Message)message, (Object)message);
                return message;
            }));
        }
        return Uni.createFrom().item(message);
    }

    private Uni<SubscribeMessage<T>> traceOutgoing(Tuple2<SubscribeMessage<T>, Message<T>> tuple) {
        if (this.configuration.trace().booleanValue()) {
            return Uni.createFrom().item(Unchecked.supplier(() -> {
                TracingUtils.traceOutgoing(this.subscriber, (Message)((Message)tuple.getItem2()), (Object)((SubscribeMessage)tuple.getItem1()));
                return (SubscribeMessage)tuple.getItem1();
            }));
        }
        return Uni.createFrom().item((Object)((SubscribeMessage)tuple.getItem1()));
    }

    private Instrumenter<SubscribeMessage<T>, Void> subscriber(OpenTelemetry openTelemetry) {
        SubscribeMessageAttributesExtractor attributesExtractor = new SubscribeMessageAttributesExtractor();
        MessagingAttributesGetter messagingAttributesGetter = attributesExtractor.getMessagingAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.smallrye.reactive.messaging.jetstream", (SpanNameExtractor)MessagingSpanNameExtractor.create(messagingAttributesGetter, (MessageOperation)MessageOperation.SEND));
        return builder.addAttributesExtractor(MessagingAttributesExtractor.create(messagingAttributesGetter, (MessageOperation)MessageOperation.SEND)).addAttributesExtractor(attributesExtractor).buildProducerInstrumenter(new SubscribeMessageTextMapSetter());
    }

    private Instrumenter<PublishMessage<T>, Void> publisher(OpenTelemetry openTelemetry) {
        PublishMessageAttributesExtractor attributesExtractor = new PublishMessageAttributesExtractor();
        MessagingAttributesGetter messagingAttributesGetter = attributesExtractor.getMessagingAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.smallrye.reactive.messaging.jetstream", (SpanNameExtractor)MessagingSpanNameExtractor.create(messagingAttributesGetter, (MessageOperation)MessageOperation.RECEIVE));
        return builder.addAttributesExtractor(attributesExtractor).addAttributesExtractor(MessagingAttributesExtractor.create(messagingAttributesGetter, (MessageOperation)MessageOperation.RECEIVE)).buildConsumerInstrumenter(new PublishMessageTextMapGetter());
    }

    private Instrumenter<ResolvedMessage<T>, Void> resolver(OpenTelemetry openTelemetry) {
        ResolvedMessageAttributesExtractor attributesExtractor = new ResolvedMessageAttributesExtractor();
        MessagingAttributesGetter messagingAttributesGetter = attributesExtractor.getMessagingAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.smallrye.reactive.messaging.jetstream", (SpanNameExtractor)MessagingSpanNameExtractor.create(messagingAttributesGetter, (MessageOperation)MessageOperation.RECEIVE));
        return builder.addAttributesExtractor(attributesExtractor).addAttributesExtractor(MessagingAttributesExtractor.create(messagingAttributesGetter, (MessageOperation)MessageOperation.RECEIVE)).buildConsumerInstrumenter(new ResolvedMessageTextMapGetter());
    }

    private Tuple2<SubscribeMessage<T>, Message<T>> createSubscribeMessage(Message<T> message, PublishConfiguration configuration) {
        byte[] payload = this.payloadMapper.of(message.getPayload());
        return Tuple2.of(SubscribeMessage.of(message, payload, configuration), message);
    }
}

