/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.SubscribeMessage;

public class SubscribeMessageAttributesExtractor<T>
implements AttributesExtractor<SubscribeMessage<T>, Void> {
    private static final String MESSAGE_PAYLOAD = "message.payload";
    private final MessagingAttributesGetter<SubscribeMessage<T>, Void> attributesGetter = new SubscribeMessagingAttributesGetter();

    public void onStart(AttributesBuilder attributes, Context parentContext, SubscribeMessage<T> message) {
        attributes.put(MESSAGE_PAYLOAD, new String(message.payload()));
    }

    public void onEnd(AttributesBuilder attributes, Context context, SubscribeMessage<T> tSubscribeMessage, Void unused, Throwable error) {
    }

    public MessagingAttributesGetter<SubscribeMessage<T>, Void> getMessagingAttributesGetter() {
        return this.attributesGetter;
    }

    private static final class SubscribeMessagingAttributesGetter<T>
    implements MessagingAttributesGetter<SubscribeMessage<T>, Void> {
        private SubscribeMessagingAttributesGetter() {
        }

        public String getSystem(SubscribeMessage<T> message) {
            return "jetstream";
        }

        public String getDestination(SubscribeMessage<T> message) {
            return String.format("%s.%s", message.stream(), message.subject());
        }

        public boolean isTemporaryDestination(SubscribeMessage<T> message) {
            return false;
        }

        public String getConversationId(SubscribeMessage<T> message) {
            return null;
        }

        public Long getMessagePayloadSize(SubscribeMessage<T> message) {
            return message.payload().length;
        }

        public Long getMessagePayloadCompressedSize(SubscribeMessage<T> message) {
            return null;
        }

        public String getMessageId(SubscribeMessage<T> message, Void unused) {
            return message.messageId();
        }
    }
}

