/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing;

import io.opentelemetry.api.OpenTelemetry;
import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamBuildConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.DefaultTracer;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.tracing.Tracer;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.PayloadMapper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;

@ApplicationScoped
public class TracerFactory {
    private final JetStreamBuildConfiguration configuration;
    private final PayloadMapper payloadMapper;
    private final Instance<OpenTelemetry> openTelemetry;

    public TracerFactory(Instance<OpenTelemetry> openTelemetryInstance, JetStreamBuildConfiguration configuration, PayloadMapper payloadMapper) {
        this.configuration = configuration;
        this.payloadMapper = payloadMapper;
        this.openTelemetry = openTelemetryInstance;
    }

    public <T> Tracer<T> create() {
        return new DefaultTracer(this.openTelemetry, this.configuration, this.payloadMapper);
    }
}

