/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.mapper;

import io.nats.client.Message;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.ExponentialBackoff;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.api.PublishMessage;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.MessageMapper;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.PayloadMapper;
import io.quarkus.arc.DefaultBean;
import io.vertx.mutiny.core.Context;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Duration;

@ApplicationScoped
@DefaultBean
public class DefaultMessageMapper
implements MessageMapper {
    private final PayloadMapper payloadMapper;

    @Inject
    public DefaultMessageMapper(PayloadMapper payloadMapper) {
        this.payloadMapper = payloadMapper;
    }

    @Override
    public <T> PublishMessage<T> of(Message message, Class<T> payloadType, Context context, ExponentialBackoff exponentialBackoff, Duration ackTimeout) {
        try {
            return payloadType != null ? new PublishMessage<T>(message, this.payloadMapper.of(message, payloadType), context, exponentialBackoff, ackTimeout) : new PublishMessage<Object>(message, this.payloadMapper.of(message).orElseGet(() -> ((Message)message).getData()), context, exponentialBackoff, ackTimeout);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
    }
}

