/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.processors.publisher;

import io.nats.client.api.AckPolicy;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.ReplayPolicy;
import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamConnectorIncomingConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.ConsumerConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.mapper.DefaultPayloadMapper;
import io.quarkiverse.reactive.messaging.nats.jetstream.processors.publisher.MessagePushPublisherConfiguration;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DefaultMessagePushPublisherConfiguration<T>
implements MessagePushPublisherConfiguration<T> {
    private final JetStreamConnectorIncomingConfiguration configuration;

    public DefaultMessagePushPublisherConfiguration(JetStreamConnectorIncomingConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Optional<Boolean> ordered() {
        return this.configuration.getPushOrdered();
    }

    @Override
    public Optional<Duration> flowControl() {
        return this.configuration.getPushFlowControl().map(Duration::parse);
    }

    @Override
    public Optional<String> deliverGroup() {
        return this.configuration.getPushDeliverGroup();
    }

    @Override
    public String subject() {
        return this.configuration.getSubject().orElseThrow(() -> new IllegalStateException("No subject configured"));
    }

    @Override
    public Optional<String> deliverSubject() {
        return Optional.empty();
    }

    @Override
    public Optional<Duration> idleHeartbeat() {
        return this.configuration.getPushIdleHeartBeat().map(Duration::parse);
    }

    @Override
    public Optional<Long> rateLimit() {
        return this.configuration.getPushRateLimit();
    }

    @Override
    public Optional<Boolean> headersOnly() {
        return Optional.empty();
    }

    @Override
    public String channel() {
        return this.configuration.getChannel();
    }

    @Override
    public Duration retryBackoff() {
        return Duration.ofMillis(this.configuration.getRetryBackoff());
    }

    @Override
    public ConsumerConfiguration<T> consumerConfiguration() {
        return new ConsumerConfiguration<T>(){

            @Override
            public String name() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getName().orElseGet(() -> this.durable().orElseGet(() -> String.format("%s-consumer", DefaultMessagePushPublisherConfiguration.this.subject()).replace("*", "").replace(".", "").replace(">", "").replace("\\", "").replace("/", "")));
            }

            @Override
            public String stream() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getStream().orElseThrow(() -> new IllegalStateException("No stream configured"));
            }

            @Override
            public Optional<String> durable() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getDurable();
            }

            @Override
            public List<String> filterSubjects() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getFilterSubjects().map(filterSubjects -> List.of(filterSubjects.split(","))).orElseGet(List::of);
            }

            @Override
            public Optional<Duration> ackWait() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getAckWait().map(Duration::parse);
            }

            @Override
            public Optional<DeliverPolicy> deliverPolicy() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getDeliverPolicy().map(DeliverPolicy::valueOf);
            }

            @Override
            public Optional<ZonedDateTime> startTime() {
                return Optional.empty();
            }

            @Override
            public Optional<String> description() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getDescription();
            }

            @Override
            public Optional<Duration> inactiveThreshold() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getInactiveThreshold().map(Duration::parse);
            }

            @Override
            public Optional<Long> maxAckPending() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getMaxAckPending();
            }

            @Override
            public Optional<Long> maxDeliver() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getMaxDeliver();
            }

            @Override
            public Optional<ReplayPolicy> replayPolicy() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getReplayPolicy().map(ReplayPolicy::valueOf);
            }

            @Override
            public Optional<Integer> replicas() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getReplicas();
            }

            @Override
            public Optional<Boolean> memoryStorage() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getMemoryStorage();
            }

            @Override
            public Optional<String> sampleFrequency() {
                return Optional.empty();
            }

            @Override
            public Map<String, String> metadata() {
                return Map.of();
            }

            @Override
            public List<Duration> backoff() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getBackOff().map(backoff -> backoff.split(",")).map(List::of).map(this::getBackOff).orElseGet(Collections::emptyList);
            }

            @Override
            public Optional<Long> startSequence() {
                return Optional.empty();
            }

            @Override
            public Optional<AckPolicy> ackPolicy() {
                return Optional.empty();
            }

            @Override
            public Optional<ZonedDateTime> pauseUntil() {
                return Optional.empty();
            }

            @Override
            public Optional<Class<T>> payloadType() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getPayloadType().map(DefaultPayloadMapper::loadClass);
            }

            @Override
            public boolean exponentialBackoff() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getExponentialBackoff() != null ? DefaultMessagePushPublisherConfiguration.this.configuration.getExponentialBackoff() : false;
            }

            @Override
            public Duration exponentialBackoffMaxDuration() {
                return DefaultMessagePushPublisherConfiguration.this.configuration.getExponentialBackoffMaxDuration() != null ? Duration.parse(DefaultMessagePushPublisherConfiguration.this.configuration.getExponentialBackoffMaxDuration()) : null;
            }

            @Override
            public Duration ackTimeout() {
                return Duration.parse(DefaultMessagePushPublisherConfiguration.this.configuration.getAckTimeout());
            }

            private List<Duration> getBackOff(List<String> backoff) {
                if (backoff == null || backoff.isEmpty()) {
                    return List.of();
                }
                return backoff.stream().map(Duration::parse).toList();
            }
        };
    }
}

