/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions;

import io.quarkus.bot.buildreporter.githubactions.BuildReporter;
import io.quarkus.bot.buildreporter.githubactions.BuildReporterConfig;
import io.quarkus.bot.buildreporter.githubactions.BuildReports;
import io.quarkus.bot.buildreporter.githubactions.WorkflowContext;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHWorkflowRun;

@Singleton
public class BuildReporterActionHandler {
    private static final Logger LOG = Logger.getLogger(BuildReporterActionHandler.class);
    @Inject
    BuildReporter buildReporter;

    public Optional<String> generateReport(GHWorkflowRun workflowRun, Path buildReportsArtifactsPath, BuildReporterConfig buildReporterConfig) throws IOException {
        Map<String, Optional<BuildReports>> buildReportsMap = this.prepareBuildReportMap(buildReportsArtifactsPath);
        return this.buildReporter.generateReportComment(workflowRun, buildReporterConfig, new WorkflowContext(workflowRun), buildReportsMap, true);
    }

    private Map<String, Optional<BuildReports>> prepareBuildReportMap(Path buildReportsArtifactsPath) {
        HashMap<String, Optional<BuildReports>> hashMap;
        block9: {
            if (!Files.exists(buildReportsArtifactsPath, new LinkOption[0]) || !Files.isDirectory(buildReportsArtifactsPath, new LinkOption[0])) {
                return Map.of();
            }
            HashMap<String, Optional<BuildReports>> buildReportsMap = new HashMap<String, Optional<BuildReports>>();
            Stream<Path> jobBuildReportsDirectoriesStream = Files.list(buildReportsArtifactsPath).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(d -> d.getFileName().toString().startsWith("build-reports-"));
            try {
                jobBuildReportsDirectoriesStream.forEach(jobBuildReportsDirectory -> {
                    String jobName = jobBuildReportsDirectory.getFileName().toString().replace("build-reports-", "");
                    BuildReports.Builder buildReportsBuilder = new BuildReports.Builder((Path)jobBuildReportsDirectory);
                    try (Stream<Path> jobBuildReportsFilesStream = Files.walk(jobBuildReportsDirectory, new FileVisitOption[0]);){
                        jobBuildReportsFilesStream.forEach(p -> buildReportsBuilder.addPath((Path)p));
                        buildReportsMap.put(jobName, Optional.of(buildReportsBuilder.build()));
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Unable to extract build reports from subdirectory " + jobBuildReportsDirectory), (Throwable)e);
                        buildReportsMap.put(jobName, Optional.empty());
                    }
                });
                hashMap = buildReportsMap;
                if (jobBuildReportsDirectoriesStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jobBuildReportsDirectoriesStream != null) {
                        try {
                            jobBuildReportsDirectoriesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error((Object)("Unable to extract build reports from directory " + buildReportsArtifactsPath), (Throwable)e);
                    return Map.of();
                }
            }
            jobBuildReportsDirectoriesStream.close();
        }
        return hashMap;
    }
}

