/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions;

import io.quarkus.bot.buildreporter.githubactions.BuildReporterConfig;
import io.quarkus.bot.buildreporter.githubactions.BuildReports;
import io.quarkus.bot.buildreporter.githubactions.StackTraceShortener;
import io.quarkus.bot.buildreporter.githubactions.WorkflowContext;
import io.quarkus.bot.buildreporter.githubactions.WorkflowReportFormatter;
import io.quarkus.bot.buildreporter.githubactions.WorkflowRunAnalyzer;
import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReport;
import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReportJob;
import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReportJobIncludeStrategy;
import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReportTestCase;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHCheckRun;
import org.kohsuke.github.GHCheckRunBuilder;
import org.kohsuke.github.GHWorkflowJob;
import org.kohsuke.github.GHWorkflowRun;

@Singleton
public class BuildReporter {
    private static final Logger LOG = Logger.getLogger(BuildReporter.class);
    private static final int GITHUB_FIELD_LENGTH_HARD_LIMIT = 65000;
    @Inject
    WorkflowRunAnalyzer workflowRunAnalyzer;
    @Inject
    WorkflowReportFormatter workflowReportFormatter;
    @Inject
    WorkflowReportJobIncludeStrategy workflowReportJobIncludeStrategy;
    @Inject
    StackTraceShortener stackTraceShortener;

    public Optional<String> generateReportComment(GHWorkflowRun workflowRun, BuildReporterConfig buildReporterConfig, WorkflowContext workflowContext, Map<String, Optional<BuildReports>> buildReportsMap, boolean artifactsAvailable) throws IOException {
        Optional<GHCheckRun> checkRunOptional;
        List<GHWorkflowJob> jobs = workflowRun.listJobs().toList().stream().sorted(buildReporterConfig.getJobNameComparator()).collect(Collectors.toList());
        Optional<WorkflowReport> workflowReportOptional = this.workflowRunAnalyzer.getReport(workflowRun, workflowContext, jobs, buildReportsMap);
        if (workflowReportOptional.isEmpty()) {
            return Optional.empty();
        }
        WorkflowReport workflowReport = workflowReportOptional.get();
        String reportComment = this.workflowReportFormatter.getReportComment(workflowReport, artifactsAvailable, (checkRunOptional = this.createCheckRun(workflowRun, buildReporterConfig, workflowContext, artifactsAvailable, workflowReport)).orElse(null), "<!-- Quarkus-GitHub-Bot/msg-id:workflow-run-status-active -->", true, true, this.workflowReportJobIncludeStrategy);
        if (reportComment.length() > 65000) {
            reportComment = this.workflowReportFormatter.getReportComment(workflowReport, artifactsAvailable, checkRunOptional.orElse(null), "<!-- Quarkus-GitHub-Bot/msg-id:workflow-run-status-active -->", false, true, this.workflowReportJobIncludeStrategy);
        }
        if (reportComment.length() > 65000) {
            reportComment = this.workflowReportFormatter.getReportComment(workflowReport, artifactsAvailable, checkRunOptional.orElse(null), "<!-- Quarkus-GitHub-Bot/msg-id:workflow-run-status-active -->", false, false, this.workflowReportJobIncludeStrategy);
        }
        return Optional.of(reportComment);
    }

    public Optional<GHCheckRun> createCheckRun(GHWorkflowRun workflowRun, BuildReporterConfig buildReporterConfig, WorkflowContext workflowContext, boolean artifactsAvailable, WorkflowReport workflowReport) {
        if (!workflowReport.hasTestFailures() || buildReporterConfig.isDryRun() || !buildReporterConfig.isCreateCheckRun()) {
            return Optional.empty();
        }
        try {
            String name = "Build summary for " + workflowRun.getHeadSha();
            String summary = this.workflowReportFormatter.getCheckRunReportSummary(workflowReport, workflowContext, artifactsAvailable, this.workflowReportJobIncludeStrategy);
            String checkRunReport = this.workflowReportFormatter.getCheckRunReport(workflowReport, true, true);
            if (checkRunReport.length() > 65000) {
                checkRunReport = this.workflowReportFormatter.getCheckRunReport(workflowReport, false, true);
            }
            if (checkRunReport.length() > 65000) {
                checkRunReport = this.workflowReportFormatter.getCheckRunReport(workflowReport, false, false);
            }
            GHCheckRunBuilder.Output checkRunOutput = new GHCheckRunBuilder.Output(name, summary).withText(checkRunReport);
            for (WorkflowReportJob workflowReportJob : workflowReport.getJobs()) {
                if (!workflowReportJob.hasTestFailures()) continue;
                List annotatedWorkflowReportTestCases = workflowReportJob.getModules().stream().filter(m -> m.hasTestFailures()).flatMap(m -> m.getTestFailures().stream()).collect(Collectors.toList());
                for (WorkflowReportTestCase workflowReportTestCase : annotatedWorkflowReportTestCases) {
                    checkRunOutput.add(new GHCheckRunBuilder.Annotation(workflowReportTestCase.getClassPath(), StringUtils.isNumeric((CharSequence)workflowReportTestCase.getFailureErrorLine()) ? Integer.valueOf(workflowReportTestCase.getFailureErrorLine()) : 1, GHCheckRun.AnnotationLevel.FAILURE, StringUtils.isNotBlank((CharSequence)workflowReportTestCase.getFailureDetail()) ? this.stackTraceShortener.shorten(workflowReportTestCase.getFailureDetail(), 65000, 3) : "The test failed.").withTitle(StringUtils.abbreviate((String)workflowReportJob.getName(), (int)255)).withRawDetails(this.stackTraceShortener.shorten(workflowReportTestCase.getFailureDetail(), 65000)));
                }
            }
            GHCheckRunBuilder checkRunBuilder = workflowRun.getRepository().createCheckRun(name, workflowRun.getHeadSha()).add(checkRunOutput).withConclusion(GHCheckRun.Conclusion.NEUTRAL).withCompletedAt(new Date());
            return Optional.of(checkRunBuilder.create());
        }
        catch (Exception e) {
            LOG.error((Object)(workflowContext.getLogContext() + " - Unable to create check run for test failures"), (Throwable)e);
            return Optional.empty();
        }
    }
}

