/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions;

import io.quarkus.bot.buildreporter.githubactions.BuildReports;
import io.quarkus.bot.buildreporter.githubactions.WorkflowContext;
import io.quarkus.bot.buildreporter.githubactions.urlshortener.UrlShortener;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHArtifact;

@ApplicationScoped
class BuildReportsUnarchiver {
    private static final Logger LOG = Logger.getLogger(BuildReportsUnarchiver.class);
    @Inject
    UrlShortener urlShortener;

    BuildReportsUnarchiver() {
    }

    public Optional<BuildReports> getBuildReports(WorkflowContext workflowContext, GHArtifact buildReportsArtifact, Path jobDirectory) throws IOException {
        ArtifactIsDownloaded artifactIsDownloaded = new ArtifactIsDownloaded(workflowContext, buildReportsArtifact, jobDirectory);
        try {
            Awaitility.await().atMost(Duration.ofMinutes(5L)).pollDelay(Duration.ofSeconds(5L)).pollInterval(Duration.ofSeconds(30L)).until((Callable)artifactIsDownloaded);
        }
        catch (ConditionTimeoutException e) {
            LOG.warn((Object)(workflowContext.getLogContext() + " - Unable to download the artifacts in a timely manner, ignoring them"));
            return Optional.empty();
        }
        return artifactIsDownloaded.getBuildReports();
    }

    private static class ArtifactIsDownloaded
    implements Callable<Boolean> {
        private static final Logger LOG = Logger.getLogger(ArtifactIsDownloaded.class);
        private final WorkflowContext workflowContext;
        private final GHArtifact buildReportsArtifact;
        private final Path jobDirectory;
        private BuildReports buildReports = null;
        private int retry = 0;

        private ArtifactIsDownloaded(WorkflowContext workflowContext, GHArtifact buildReportsArtifact, Path jobDirectory) {
            this.workflowContext = workflowContext;
            this.buildReportsArtifact = buildReportsArtifact;
            this.jobDirectory = jobDirectory;
        }

        @Override
        public Boolean call() {
            try {
                ++this.retry;
                this.buildReports = (BuildReports)this.buildReportsArtifact.download(is -> this.unzip((InputStream)is, this.jobDirectory));
                return true;
            }
            catch (Exception e) {
                LOG.error((Object)(this.workflowContext.getLogContext() + " - Unable to download artifact " + this.buildReportsArtifact.getName() + "- retry #" + this.retry), (Throwable)e);
                return false;
            }
        }

        public Optional<BuildReports> getBuildReports() {
            return Optional.ofNullable(this.buildReports);
        }

        private BuildReports unzip(InputStream inputStream, Path jobDirectory) throws IOException {
            BuildReports.Builder buildReportsBuilder = new BuildReports.Builder(jobDirectory);
            try (ZipInputStream zis = new ZipInputStream(inputStream);){
                byte[] buffer = new byte[1024];
                ZipEntry zipEntry = zis.getNextEntry();
                while (zipEntry != null) {
                    Path newPath = ArtifactIsDownloaded.getZipEntryPath(jobDirectory, zipEntry);
                    File newFile = newPath.toFile();
                    buildReportsBuilder.addPath(newPath);
                    if (zipEntry.isDirectory()) {
                        if (!newFile.isDirectory() && !newFile.mkdirs()) {
                            throw new IOException("Failed to create directory " + newFile);
                        }
                    } else {
                        int len;
                        File parent = newFile.getParentFile();
                        if (!parent.isDirectory() && !parent.mkdirs()) {
                            throw new IOException("Failed to create directory " + parent);
                        }
                        FileOutputStream fos = new FileOutputStream(newFile);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                    }
                    zipEntry = zis.getNextEntry();
                }
                zis.closeEntry();
            }
            return buildReportsBuilder.build();
        }

        private static Path getZipEntryPath(Path destinationDirectory, ZipEntry zipEntry) throws IOException {
            Path destinationFile = destinationDirectory.resolve(zipEntry.getName());
            if (!destinationFile.toAbsolutePath().startsWith(destinationDirectory.toAbsolutePath())) {
                throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
            }
            return destinationFile;
        }
    }
}

