/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bot.buildreporter.githubactions.report;

import io.quarkus.bot.build.reporting.model.BuildStatus;
import io.quarkus.bot.build.reporting.model.ProjectReport;
import io.quarkus.bot.buildreporter.githubactions.report.WorkflowReportTestCase;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.List;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;

@RegisterForReflection
public class WorkflowReportModule {
    private final String name;
    private final ProjectReport projectReport;
    private final String projectReportFailure;
    private final List<ReportTestSuite> reportTestSuites;
    private final List<WorkflowReportTestCase> failures;

    public WorkflowReportModule(String name, ProjectReport projectReport, String projectReportFailure, List<ReportTestSuite> reportTestSuites, List<WorkflowReportTestCase> failures) {
        this.name = name;
        this.projectReport = projectReport;
        this.projectReportFailure = projectReportFailure;
        this.reportTestSuites = reportTestSuites;
        this.failures = failures;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasReportedFailures() {
        return this.hasTestFailures() || this.hasBuildReportFailures();
    }

    public boolean hasTestFailures() {
        for (ReportTestSuite reportTestSuite : this.reportTestSuites) {
            if (reportTestSuite.getNumberOfErrors() <= 0 && reportTestSuite.getNumberOfFailures() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasBuildReportFailures() {
        return this.projectReport != null && this.projectReport.getStatus() == BuildStatus.FAILURE;
    }

    public List<WorkflowReportTestCase> getTestFailures() {
        return this.failures;
    }

    public int getTestCount() {
        int testCount = 0;
        for (ReportTestSuite reportTestSuite : this.reportTestSuites) {
            testCount += reportTestSuite.getNumberOfTests();
        }
        return testCount;
    }

    public int getSuccessCount() {
        int successCount = 0;
        for (ReportTestSuite reportTestSuite : this.reportTestSuites) {
            for (ReportTestCase reportTestCase : reportTestSuite.getTestCases()) {
                if (!reportTestCase.isSuccessful()) continue;
                ++successCount;
            }
        }
        return successCount;
    }

    public int getErrorCount() {
        int testCount = 0;
        for (ReportTestSuite reportTestSuite : this.reportTestSuites) {
            testCount += reportTestSuite.getNumberOfErrors();
        }
        return testCount;
    }

    public int getFailureCount() {
        int testCount = 0;
        for (ReportTestSuite reportTestSuite : this.reportTestSuites) {
            testCount += reportTestSuite.getNumberOfFailures();
        }
        return testCount;
    }

    public int getSkippedCount() {
        int testCount = 0;
        for (ReportTestSuite reportTestSuite : this.reportTestSuites) {
            testCount += reportTestSuite.getNumberOfSkipped();
        }
        return testCount;
    }

    public String getProjectReportFailure() {
        return this.projectReportFailure;
    }
}

